/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.google.common.collect.ImmutableSet;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import jakarta.mail.internet.ContentType;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jetbrains.annotations.NotNull;

public class ContentTypeDetector {
    private static final Set<String> contentTypesXML = ImmutableSet.of((Object)"text/xml", (Object)"application/xml", (Object)"multipart/related");
    private static final Set<String> contentTypesHTML = ImmutableSet.of((Object)"text/html");
    private static final Set<String> contentTypesJSON = ImmutableSet.of((Object)"application/json", (Object)"application/x-javascript", (Object)"text/javascript", (Object)"text/x-javascript", (Object)"text/x-json", (Object)"application/problem+json", (Object[])new String[0]);
    private static final XOPReconstitutor xopr = new XOPReconstitutor();

    public static EffectiveContentType detectEffectiveContentType(Message m) {
        try {
            ContentType t = m.getHeader().getContentTypeObject();
            if (t == null) {
                return EffectiveContentType.UNKNOWN;
            }
            String type = t.getPrimaryType() + "/" + t.getSubType();
            if (contentTypesJSON.contains(type)) {
                return EffectiveContentType.JSON;
            }
            if (contentTypesXML.contains(type)) {
                return ContentTypeDetector.analyseXMLContent(m);
            }
            if (contentTypesHTML.contains(type)) {
                return EffectiveContentType.HTML;
            }
            if (t.getPrimaryType().equals("text")) {
                return EffectiveContentType.TEXT;
            }
            if (t.getSubType().endsWith("+json")) {
                return EffectiveContentType.JSON;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EffectiveContentType.UNKNOWN;
    }

    @NotNull
    private static EffectiveContentType analyseXMLContent(Message m) {
        try {
            XMLStreamReader reader = ContentTypeDetector.getXMLInputFactory().createXMLStreamReader(xopr.reconstituteIfNecessary(m));
            if (reader.nextTag() == 1 && ContentTypeDetector.isSOAP(reader)) {
                return EffectiveContentType.SOAP;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EffectiveContentType.XML;
    }

    private static boolean isSOAP(XMLStreamReader reader) {
        return "http://schemas.xmlsoap.org/soap/envelope/".equals(reader.getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equals(reader.getNamespaceURI());
    }

    private static XMLInputFactory getXMLInputFactory() {
        XMLInputFactory f = XMLInputFactory.newInstance();
        f.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        f.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return f;
    }

    public static enum EffectiveContentType {
        SOAP,
        XML,
        JSON,
        HTML,
        TEXT,
        UNKNOWN;

    }
}

