/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.transport.http.EOFWhileReadingLineException;
import com.predic8.membrane.core.transport.http.LineTooLongException;
import com.predic8.membrane.core.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.text.StringEscapeUtils;

public class HttpUtil {
    private static final DateFormat GMT_DATE_FORMAT = HttpUtil.createGMTDateFormat();
    private static final int MAX_LINE_LENGTH;

    public static List<String> getForwardedForList(Exchange exc) {
        String normalizedHeader = exc.getRequest().getHeader().getNormalizedValue("X-Forwarded-For");
        if (normalizedHeader == null) {
            return Collections.emptyList();
        }
        ArrayList<String> xForwardedFor = new ArrayList<String>(Util.splitStringByComma(normalizedHeader).stream().map(String::trim).toList());
        int addrIdx = xForwardedFor.lastIndexOf(exc.getRemoteAddrIp());
        if (!xForwardedFor.isEmpty() && addrIdx > -1) {
            xForwardedFor.remove(addrIdx);
        }
        return xForwardedFor;
    }

    public static DateFormat createGMTDateFormat() {
        SimpleDateFormat gmtDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        gmtDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return gmtDateFormat;
    }

    public static String readLine(InputStream in) throws IOException {
        int b;
        StringBuilder line = new StringBuilder(128);
        int l = 0;
        while ((b = in.read()) != -1) {
            if (b == 13) {
                in.read();
                return line.toString();
            }
            if (b == 10) {
                in.mark(2);
                if (in.read() != 13) {
                    in.reset();
                }
                return line.toString();
            }
            line.append((char)b);
            if (++l != MAX_LINE_LENGTH) continue;
            throw new LineTooLongException(line.toString());
        }
        throw new EOFWhileReadingLineException(line.toString());
    }

    public static Response setHTMLErrorResponse(Response.ResponseBuilder responseBuilder, String message, String comment) {
        Response response = responseBuilder.build();
        response.setHeader(HttpUtil.createHeaders("text/html;charset=UTF-8", new String[0]));
        response.setBodyContent(HttpUtil.getHTMLErrorBody(message, comment).getBytes(StandardCharsets.UTF_8));
        return response;
    }

    private static String getHTMLErrorBody(String text, String comment) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \r\n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head>\r\n<title>Internal Server Error</title>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\r\n<style><!--\r\nbody { font-family:sans-serif; } \r\n.footer { margin-top:20pt; color:#AAAAAA; padding:1em 0em; font-size:10pt; }\r\n.footer a { color:#AAAAAA; }\r\n.footer a:hover { color:#000000; }\r\n--></style></head>\r\n<body><h1>Internal Server Error</h1>");
        buf.append("<hr/>");
        buf.append("<p>While processing your request, the following error was detected. ");
        buf.append(comment);
        buf.append("</p>\r\n");
        buf.append("<pre id=\"msg\">");
        buf.append(StringEscapeUtils.escapeHtml4((String)text));
        buf.append("</pre>");
        buf.append("<p class=\"footer\">");
        buf.append("Copyright &copy;2009-2025 <a href=\"http://predic8.com/\">predic8 GmbH</a>. All Rights Reserved. See <a href=\"http://www.membrane-soa.org/api-gateway/\">http://www.membrane-soa.org/api-gateway/</a> for documentation and updates.");
        buf.append("</p>");
        buf.append("</body>");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Header createHeaders(String contentType, String ... headers) {
        Header header = new Header();
        if (contentType != null) {
            header.setContentType(contentType);
        }
        DateFormat dateFormat = GMT_DATE_FORMAT;
        synchronized (dateFormat) {
            header.add("Date", GMT_DATE_FORMAT.format(new Date()));
        }
        header.add("Server", "Membrane API Gateway");
        header.add("Connection", "close");
        for (int i = 0; i < headers.length; i += 2) {
            header.add(headers[i], headers[i + 1]);
        }
        return header;
    }

    public static String getPathAndQueryString(String dest) throws MalformedURLException {
        URL url = new URL(dest);
        String uri = url.getPath();
        if (url.getQuery() != null) {
            return uri + "?" + url.getQuery();
        }
        return uri;
    }

    public static int getPort(URL url) {
        int port = url.getPort();
        if (port == -1 && (port = url.getDefaultPort()) == -1) {
            return 80;
        }
        return port;
    }

    public static boolean isAbsoluteURI(String uri) {
        return (uri = uri.toLowerCase()).startsWith("http://") || uri.startsWith("https://");
    }

    public static String getMessageForStatusCode(int code) {
        return switch (code) {
            case 100 -> "Continue";
            case 200 -> "Ok";
            case 201 -> "Created";
            case 202 -> "Accepted";
            case 204 -> "No Content";
            case 206 -> "Partial Content";
            case 301 -> "Moved Permanently";
            case 302 -> "Found";
            case 304 -> "Not Modified";
            case 307 -> "Temporary Redirect";
            case 308 -> "Permanent Redirect";
            case 400 -> "Bad Request";
            case 401 -> "Unauthorized";
            case 403 -> "Forbidden";
            case 404 -> "Not Found";
            case 405 -> "Method Not Allowed";
            case 409 -> "Conflict";
            case 415 -> "Unsupported Mediatype";
            case 422 -> "Unprocessable Entity";
            case 500 -> "Internal Server Error";
            case 501 -> "Not Implemented";
            case 502 -> "Bad Gateway";
            case 503 -> "Service Unavailable";
            case 504 -> "Gateway Timeout";
            default -> "";
        };
    }

    public static String unescapedHtmlMessage(String caption, String text) {
        return "<html><head><title>" + caption + "</title></head><body><h1>" + caption + "</h1><p>" + text + "</p></body></html>";
    }

    public static String htmlMessage(String caption, String text) {
        return HttpUtil.unescapedHtmlMessage(StringEscapeUtils.escapeHtml4((String)caption), StringEscapeUtils.escapeHtml4((String)text));
    }

    static {
        String maxLineLength = System.getProperty("membrane.core.http.body.maxlinelength");
        MAX_LINE_LENGTH = maxLineLength == null ? 8092 : Integer.parseInt(maxLineLength);
    }
}

