/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;

public class LSInputImpl
implements LSInput {
    private static final Logger log = LoggerFactory.getLogger((String)LSInputImpl.class.getName());
    private String publicId;
    private String systemId;
    private InputStream inputStream;

    public LSInputImpl(String publicId, String systemId, InputStream inputStream) throws IOException {
        this.publicId = publicId;
        this.systemId = systemId;
        this.inputStream = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(inputStream)).setInclude(false).get();
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public InputStream getByteStream() {
        return null;
    }

    @Override
    public boolean getCertifiedText() {
        return false;
    }

    @Override
    public Reader getCharacterStream() {
        return null;
    }

    @Override
    public String getEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStringData() {
        InputStream inputStream = this.inputStream;
        synchronized (inputStream) {
            try {
                return this.streamToString();
            }
            catch (IOException e) {
                log.error("Unable to read stream: " + String.valueOf(e));
                return "";
            }
        }
    }

    private String streamToString() throws IOException {
        return new String(this.inputStream.readAllBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public void setBaseURI(String baseURI) {
    }

    @Override
    public void setByteStream(InputStream byteStream) {
        this.inputStream = byteStream;
    }

    @Override
    public void setCertifiedText(boolean certifiedText) {
    }

    @Override
    public void setCharacterStream(Reader characterStream) {
    }

    @Override
    public void setEncoding(String encoding) {
    }

    @Override
    public void setStringData(String stringData) {
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
}

