/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import java.util.List;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.springframework.beans.factory.InitializingBean;

@MCElement(name="memcached")
public class MemcachedConnector
implements InitializingBean {
    private String host = "localhost";
    private int port = 11211;
    private String username;
    private String password;
    private MemcachedClient client;
    private long connectTimeout = 60000L;

    public void afterPropertiesSet() throws Exception {
        List servers = AddrUtil.getAddresses((String)(this.host + ":" + this.port));
        XMemcachedClientBuilder builder = new XMemcachedClientBuilder(servers);
        if (this.username != null || this.password != null) {
            AuthInfo authInfo = AuthInfo.plain((String)this.username, (String)this.password);
            servers.forEach(server -> builder.addAuthInfo(server, authInfo));
        }
        builder.setCommandFactory((CommandFactory)new BinaryCommandFactory());
        builder.setConnectTimeout(this.connectTimeout);
        this.client = builder.build();
    }

    public MemcachedClient getClient() {
        return this.client;
    }

    public String getHost() {
        return this.host;
    }

    @MCAttribute
    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    @MCAttribute
    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    @MCAttribute
    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    @MCAttribute
    public void setPassword(String password) {
        this.password = password;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @MCAttribute
    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }
}

