/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.interceptor.schemavalidation.SOAPXMLFilter;
import com.predic8.membrane.core.util.ByteUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.brotli.dec.BrotliInputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MessageUtil {
    private static final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();

    public static InputStream getContentAsStream(Message res) throws IOException {
        if (res.isGzip()) {
            return new GZIPInputStream(res.getBodyAsStream());
        }
        if (res.isDeflate()) {
            return new ByteArrayInputStream(ByteUtil.getDecompressedData(res.getBody().getContent()));
        }
        if (res.isBrotli()) {
            return new BrotliInputStream(res.getBodyAsStream());
        }
        return res.getBodyAsStream();
    }

    public static byte[] getContent(Message res) throws Exception {
        if (res.isGzip()) {
            return ByteUtil.getByteArrayData(new GZIPInputStream(res.getBodyAsStream()));
        }
        if (res.isDeflate()) {
            return ByteUtil.getDecompressedData(res.getBody().getContent());
        }
        if (res.isBrotli()) {
            return new BrotliInputStream(res.getBodyAsStream()).readAllBytes();
        }
        return res.getBody().getContent();
    }

    public static Source getSOAPBody(InputStream stream) {
        try {
            return new SAXSource(new SOAPXMLFilter(saxParserFactory.newSAXParser().getXMLReader()), new InputSource(stream));
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Error initializing SAXSource", e);
        }
    }

    public static Request getGetRequest(String uri) {
        Request req = MessageUtil.getStandartRequest("GET");
        req.setUri(uri);
        return req;
    }

    public static Request getPostRequest(String uri) {
        Request req = MessageUtil.getStandartRequest("POST");
        req.setUri(uri);
        return req;
    }

    public static Request getDeleteRequest(String uri) {
        Request req = MessageUtil.getStandartRequest("DELETE");
        req.setUri(uri);
        return req;
    }

    private static Request getStandartRequest(String method) {
        Request request = new Request();
        request.setMethod(method);
        request.setVersion("1.1");
        return request;
    }

    static {
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setValidating(false);
    }
}

