/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

public class OSUtil {
    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().contains("mac");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("inx");
    }

    public static OS getOS() {
        if (OSUtil.isWindows()) {
            return OS.WINDOWS;
        }
        if (OSUtil.isLinux()) {
            return OS.LINUX;
        }
        if (OSUtil.isMac()) {
            return OS.MAC;
        }
        return OS.UNKNOWN;
    }

    public static String fixBackslashes(String s) {
        return s.replaceAll("\\\\", "/");
    }

    public static String wl(String windows, String linux) {
        if (OSUtil.isWindows()) {
            return windows;
        }
        return linux;
    }

    public static enum OS {
        WINDOWS,
        MAC,
        LINUX,
        UNKNOWN;

    }
}

