/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.InitializingBean;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.params.GetExParams;

@MCElement(name="redis", topLevel=true)
public class RedisConnector
implements InitializingBean {
    private JedisPool pool;
    private JedisSentinelPool sentinelPool;
    private String host = "localhost";
    private int dbNumber = 0;
    private int port = 6379;
    private int connectionNumber = 20;
    private int minIdleConnection = 10;
    private int timeout = 5000;
    private boolean ssl = false;
    private String user;
    private String password;
    private GetExParams params;
    private boolean useSentinels = false;
    private String masterName = "mymaster";

    public void afterPropertiesSet() throws Exception {
        GenericObjectPoolConfig jedisPoolConfig = new GenericObjectPoolConfig();
        jedisPoolConfig.setMaxTotal(this.connectionNumber);
        jedisPoolConfig.setMaxIdle(this.connectionNumber);
        jedisPoolConfig.setMinIdle(this.minIdleConnection);
        jedisPoolConfig.setMaxWaitMillis((long)this.timeout);
        if (this.useSentinels) {
            HashSet<CallSite> sentinels = new HashSet<CallSite>();
            sentinels.add((CallSite)((Object)(this.host + ":" + this.port)));
            this.sentinelPool = new JedisSentinelPool(this.masterName, sentinels, jedisPoolConfig, this.timeout);
        } else {
            this.pool = this.user == null && this.password != null ? new JedisPool(jedisPoolConfig, this.host, this.port, this.timeout, this.password, this.ssl) : (this.user != null && this.password != null ? new JedisPool(jedisPoolConfig, this.host, this.port, this.timeout, this.user, this.password, this.ssl) : new JedisPool(jedisPoolConfig, this.host, this.port, this.ssl));
        }
        this.params = new GetExParams().ex((long)this.getTimeout());
    }

    public Jedis getJedisWithDb() {
        Jedis jedis;
        if (this.sentinelPool != null) {
            jedis = this.sentinelPool.getResource();
            if (this.password != null) {
                if (this.user != null) {
                    jedis.auth(this.user, this.password);
                } else {
                    jedis.auth(this.password);
                }
            }
        } else {
            jedis = this.pool.getResource();
        }
        jedis.select(this.dbNumber);
        return jedis;
    }

    public JedisPool getPool() {
        return this.pool;
    }

    public int getConnectionNumber() {
        return this.connectionNumber;
    }

    @MCAttribute
    public void setConnectionNumber(int connectionNumber) {
        this.connectionNumber = connectionNumber;
    }

    public int getMinIdleConnection() {
        return this.minIdleConnection;
    }

    @MCAttribute
    public void setMinIdleConnection(int minIdleConnection) {
        this.minIdleConnection = minIdleConnection;
    }

    public GetExParams getParams() {
        return this.params;
    }

    public void setParams(GetExParams params) {
        this.params = params;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @MCAttribute
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getUser() {
        return this.user;
    }

    @MCAttribute
    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    @MCAttribute
    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    @MCAttribute
    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getHost() {
        return this.host;
    }

    @MCAttribute
    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    @MCAttribute
    public void setPort(int port) {
        this.port = port;
    }

    public int getDbNumber() {
        return this.dbNumber;
    }

    @MCAttribute
    public void setDbNumber(int dbNumber) {
        this.dbNumber = dbNumber;
    }

    public boolean isUseSentinels() {
        return this.useSentinels;
    }

    @MCAttribute
    public void setUseSentinels(boolean useSentinels) {
        this.useSentinels = useSentinels;
    }

    public String getMasterName() {
        return this.masterName;
    }

    @MCAttribute
    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }
}

