/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import com.predic8.membrane.core.util.HttpUtil;
import com.predic8.membrane.core.util.XMLUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAPUtil {
    private static final Logger log = LoggerFactory.getLogger((String)SOAPUtil.class.getName());
    public static final SOAPAnalysisResult NO_SOAP_RESULT = new SOAPAnalysisResult(false, false, null, null);

    public static boolean isSOAP(XOPReconstitutor xopr, Message msg) {
        try {
            XMLEventReader parser = XMLInputFactory.newInstance().createXMLEventReader(xopr.reconstituteIfNecessary(msg));
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (!event.isStartElement()) continue;
                QName name = ((StartElement)event).getName();
                return (SOAPUtil.isSOAP11Element(name) || SOAPUtil.isSOAP12Element(name)) && "Envelope".equals(name.getLocalPart());
            }
        }
        catch (Exception e) {
            log.warn("Ignoring exception: ", (Throwable)e);
        }
        return false;
    }

    public static Response createSOAPFaultResponse(FaultCode code, String faultstring, Map<String, Object> details) {
        Response response = SOAPUtil.createRawSOAPErrorResponse();
        try {
            response.setBodyContent(XMLUtil.xml2string(SOAPUtil.createSOAP11Fault(code, faultstring, details)).getBytes(StandardCharsets.UTF_8));
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    public static Element createSOAP11Fault(FaultCode faultcode, String faultstring, Map<String, Object> detail) throws ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element env = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Envelope");
        env.setAttribute("xmlns:soap", "http://schemas.xmlsoap.org/soap/envelope/");
        doc.appendChild(env);
        Element body = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Body");
        env.appendChild(body);
        Element fault = doc.createElement("Fault");
        body.appendChild(fault);
        Element faultCode = doc.createElement("faultcode");
        faultCode.setTextContent(faultcode.name());
        fault.appendChild(faultCode);
        Element faultString = doc.createElement("faultstring");
        faultString.setTextContent(faultstring);
        fault.appendChild(faultString);
        if (detail != null && !detail.isEmpty()) {
            Element detailElement = doc.createElement("detail");
            XMLUtil.mapToXml(doc, detailElement, detail);
            fault.appendChild(detailElement);
        }
        return env;
    }

    @NotNull
    private static Response createRawSOAPErrorResponse() {
        Response response = new Response();
        response.setStatusCode(200);
        response.setStatusMessage("Bad request");
        response.setHeader(HttpUtil.createHeaders("text/xml;charset=UTF-8", new String[0]));
        return response;
    }

    public static String getFaultSOAP12Body(String title, String text) {
        return "<soapenv:Envelope xmlns:soapenv=\"%s\">\n<soapenv:Body>\n<soapenv:Fault>\n<soapenv:Code>\n<soapenv:Value>soapenv:Receiver</soapenv:Value>\n</soapenv:Code>\n<soapenv:Reason><soapenv:Text xml:lang=\"en-US\">%s</soapenv:Text></soapenv:Reason>\n<soapenv:Detail><Text>%s</Text></soapenv:Detail>\n</soapenv:Fault>\n</soapenv:Body>\n</soapenv:Envelope>".formatted("http://www.w3.org/2003/05/soap-envelope", StringEscapeUtils.escapeXml11((String)title), StringEscapeUtils.escapeXml11((String)text)).replace("\n", "\r\n");
    }

    public static SOAPAnalysisResult analyseSOAPMessage(XOPReconstitutor xopr, Message msg) {
        try {
            XMLInputFactory f = XMLInputFactory.newInstance();
            f.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            f.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            XMLEventReader parser = f.createXMLEventReader(xopr.reconstituteIfNecessary(msg));
            Constants.SoapVersion version = null;
            int state = 0;
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (event.isStartElement()) {
                    String expected;
                    QName name = ((StartElement)event).getName();
                    if (state < 2 && !SOAPUtil.isSOAP11Element(name) && !SOAPUtil.isSOAP12Element(name)) {
                        return NO_SOAP_RESULT;
                    }
                    if ("Header".equals(name.getLocalPart())) {
                        SOAPUtil.readUntilEndTag(parser);
                        continue;
                    }
                    switch (state) {
                        case 0: {
                            expected = "Envelope";
                            break;
                        }
                        case 1: {
                            expected = "Body";
                            break;
                        }
                        case 2: {
                            expected = "Fault";
                            break;
                        }
                        default: {
                            return NO_SOAP_RESULT;
                        }
                    }
                    if ("Envelope".equals(name.getLocalPart())) {
                        state = 1;
                        version = SOAPUtil.getSOAPVersion(name);
                        continue;
                    }
                    if (expected.equals(name.getLocalPart())) {
                        switch (state) {
                            case 0: {
                                version = SOAPUtil.getSOAPVersion(name);
                                break;
                            }
                            case 2: {
                                return new SOAPAnalysisResult(true, true, version, null);
                            }
                            default: {
                                ++state;
                                break;
                            }
                        }
                    } else {
                        if (state == 2) {
                            return new SOAPAnalysisResult(true, false, version, name);
                        }
                        return NO_SOAP_RESULT;
                    }
                }
                if (!event.isEndElement()) continue;
                return NO_SOAP_RESULT;
            }
        }
        catch (Exception e) {
            log.warn("Ignoring exception: ", (Throwable)e);
        }
        return NO_SOAP_RESULT;
    }

    private static Constants.SoapVersion getSOAPVersion(QName name) {
        return switch (name.getNamespaceURI()) {
            case "http://schemas.xmlsoap.org/soap/envelope/" -> Constants.SoapVersion.SOAP11;
            case "http://www.w3.org/2003/05/soap-envelope" -> Constants.SoapVersion.SOAP12;
            default -> Constants.SoapVersion.UNKNOWN;
        };
    }

    public static boolean isSOAP12Element(QName name) {
        return "http://www.w3.org/2003/05/soap-envelope".equals(name.getNamespaceURI());
    }

    public static boolean isSOAP11Element(QName name) {
        return "http://schemas.xmlsoap.org/soap/envelope/".equals(name.getNamespaceURI());
    }

    private static void readUntilEndTag(XMLEventReader parser) throws XMLStreamException {
        int stack = 0;
        while (parser.hasNext()) {
            XMLEvent event = parser.nextEvent();
            if (event.isStartElement()) {
                ++stack;
            }
            if (!event.isEndElement()) continue;
            if (stack == 0) break;
            --stack;
        }
    }

    public static enum FaultCode {
        Server,
        Client;

    }

    public record SOAPAnalysisResult(boolean isSOAP, boolean isFault, Constants.SoapVersion version, QName soapElement) {
    }
}

