/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.beautifier.HtmlBeautifierFormatter;
import com.predic8.beautifier.PlainBeautifierFormatter;
import com.predic8.beautifier.XMLBeautifier;
import com.predic8.beautifier.XMLBeautifierFormatter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUtil {
    private static final Logger log = LoggerFactory.getLogger((String)TextUtil.class.getName());
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private static final char[] source = new char[]{'*', '?', '.', '\\', '(', ')', '+', '|', '^', '$', '%', '@'};
    private static final String[] replace = new String[]{".*", ".", "\\.", "\\\\", "\\(", "\\)", "\\+", "\\|", "\\^", "\\$", "\\%", "\\@"};

    public static String camelToKebab(String string) {
        String kebab = string.replaceAll("([a-z0-9])([A-Z])", "$1-$2");
        kebab = kebab.replaceAll("([A-Z])([A-Z][a-z])", "$1-$2");
        return kebab.toLowerCase();
    }

    public static String formatXML(Reader reader) throws Exception {
        return TextUtil.formatXML(reader, false);
    }

    public static String formatXML(Reader reader, boolean asHTML) throws Exception {
        StringWriter out = new StringWriter();
        try {
            HtmlBeautifierFormatter formatter = asHTML ? new HtmlBeautifierFormatter((Writer)out, 0) : new PlainBeautifierFormatter((Writer)out, 0);
            XMLBeautifier beautifier = new XMLBeautifier((XMLBeautifierFormatter)formatter);
            beautifier.parse(reader);
        }
        catch (Exception e) {
            log.warn("Error parsing XML: {}", (Object)e.getMessage());
            throw e;
        }
        finally {
            try {
                out.close();
                reader.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        return out.toString();
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String globToRegExp(String glob) {
        StringBuilder buf = new StringBuilder();
        buf.append("^");
        for (int i = 0; i < glob.length(); ++i) {
            TextUtil.appendReplacement(glob.charAt(i), buf);
        }
        buf.append("$");
        return buf.toString();
    }

    private static void appendReplacement(char c, StringBuilder buf) {
        for (int j = 0; j < source.length; ++j) {
            if (c != source[j]) continue;
            buf.append(replace[j]);
            return;
        }
        buf.append(c);
    }

    public static String toEnglishList(String conjuction, String ... args) {
        ArrayList<String> l = new ArrayList<String>();
        for (String arg : args) {
            if (arg == null || arg.isEmpty()) continue;
            l.add(arg);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < l.size(); ++i) {
            sb.append((String)l.get(i));
            if (i == l.size() - 2) {
                sb.append(" ");
                sb.append(conjuction);
                sb.append(" ");
            }
            if (i >= l.size() - 2) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static Object capitalize(String english) {
        if (english.isEmpty()) {
            return "";
        }
        return (english.charAt(0) + english.substring(1)).toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidXMLSnippet(String s) {
        try {
            XMLEventReader parser;
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                parser = xmlInputFactory.createXMLEventReader(new StringReader("<a>" + s + "</a>"));
            }
            XMLEvent event = null;
            while (parser.hasNext()) {
                event = (XMLEvent)parser.next();
            }
            return event != null && event.isEndDocument();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    public static String linkURL(String url) {
        if (url.startsWith("http://") || url.startsWith("https://")) {
            url = StringEscapeUtils.escapeHtml4((String)url);
            return "<a href=\"" + url + "\">" + url + "</a>";
        }
        return StringEscapeUtils.escapeHtml4((String)url);
    }

    public static Object removeFinalChar(String s) {
        StringBuilder sb = new StringBuilder(s);
        if (!sb.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String getLineFromMultilineString(String s, int lineNumber) {
        return s.split("\n")[lineNumber - 1];
    }

    public static String escapeQuotes(String s) {
        return s.replace("\"", "\\\"");
    }

    public static String unifyIndent(String multilineString) {
        String[] lines = multilineString.split("\r?\n");
        return TextUtil.trimLines(lines, TextUtil.getMinIndent(lines)).toString().replaceFirst("\\s*$", "");
    }

    public static StringBuilder trimLines(String[] lines, int minIndent) {
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            if (!line.trim().isEmpty()) {
                result.append(" ".repeat(Math.max(TextUtil.getCurrentIndent(line) - minIndent, 0))).append(line.trim()).append("\n");
                continue;
            }
            result.append("\n");
        }
        return result;
    }

    public static int getCurrentIndent(String line) {
        return line.length() - line.replaceFirst("^\\s+", "").length();
    }

    public static int getMinIndent(String[] lines) {
        int minIndent = Integer.MAX_VALUE;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            int leadingSpaces = TextUtil.getCurrentIndent(line);
            minIndent = Math.min(minIndent, leadingSpaces);
        }
        return minIndent;
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }
}

