/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URI {
    private java.net.URI uri;
    private String input;
    private String path;
    private String query;
    private String scheme;
    private String host;
    private int port = -1;
    private String pathDecoded;
    private String queryDecoded;
    private static final Pattern PATTERN = Pattern.compile("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?");

    URI(boolean allowCustomParsing, String s) throws URISyntaxException {
        try {
            this.uri = new java.net.URI(s);
        }
        catch (URISyntaxException e) {
            if (allowCustomParsing && this.customInit(s)) {
                return;
            }
            throw e;
        }
    }

    URI(String s, boolean useCustomParsing) throws URISyntaxException {
        if (useCustomParsing) {
            if (!this.customInit(s)) {
                throw new URISyntaxException(s, "URI did not match regular expression.");
            }
        } else {
            this.uri = new java.net.URI(s);
        }
    }

    private boolean customInit(String s) {
        Matcher m = PATTERN.matcher(s);
        if (!m.matches()) {
            return false;
        }
        this.input = s;
        this.scheme = m.group(2);
        this.processHostAndPort(m.group(4));
        this.path = m.group(5);
        this.query = m.group(7);
        return true;
    }

    private void processHostAndPort(String hostAndPort) {
        if (hostAndPort != null) {
            int pos;
            int posAt = hostAndPort.indexOf("@");
            if (posAt > -1) {
                hostAndPort = hostAndPort.substring(posAt + 1);
            }
            if ((pos = hostAndPort.indexOf(":")) > -1) {
                this.host = hostAndPort.substring(0, pos);
                this.port = Integer.parseInt(hostAndPort.substring(pos + 1));
            } else {
                this.host = hostAndPort;
            }
        }
    }

    public String getScheme() {
        if (this.uri != null) {
            return this.uri.getScheme();
        }
        return this.scheme;
    }

    public String getHost() {
        if (this.uri != null) {
            return this.uri.getHost();
        }
        return this.host;
    }

    public int getPort() {
        if (this.uri != null) {
            return this.uri.getPort();
        }
        return this.port;
    }

    public String getPath() {
        if (this.uri != null) {
            return this.uri.getPath();
        }
        if (this.pathDecoded == null) {
            this.pathDecoded = this.decode(this.path);
        }
        return this.pathDecoded;
    }

    public String getRawPath() {
        if (this.uri != null) {
            return this.uri.getRawPath();
        }
        return this.path;
    }

    public String getQuery() {
        if (this.uri != null) {
            return this.uri.getQuery();
        }
        if (this.queryDecoded == null) {
            this.queryDecoded = this.decode(this.query);
        }
        return this.queryDecoded;
    }

    private String decode(String string) {
        if (string == null) {
            return string;
        }
        return URLDecoder.decode(string, StandardCharsets.UTF_8);
    }

    public String getRawQuery() {
        if (this.uri != null) {
            return this.uri.getRawQuery();
        }
        return this.query;
    }

    public String toString() {
        if (this.uri != null) {
            return this.uri.toString();
        }
        return this.input;
    }
}

