/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class URIUtil {
    private static final Pattern driveLetterPattern = Pattern.compile("^(\\w)[/:|].*");

    public static String toFileURIString(File f) throws URISyntaxException {
        return URIUtil.convertPath2FileURI(f.getAbsolutePath()).toString();
    }

    public static URI convertPath2FileURI(String path) throws URISyntaxException {
        return new URI(URIUtil.addFilePrefix(URIUtil.encodePathCharactersForUri(path)));
    }

    public static String encodePathCharactersForUri(String s) {
        return s.replaceAll(" ", "%20").replace("\\", "/");
    }

    @NotNull
    private static String addFilePrefix(String path) {
        if (!((String)path).startsWith("file:")) {
            path = "file:" + (String)path;
        }
        if (((String)path).charAt(5) != '/') {
            path = "file:/" + ((String)path).substring(5);
        }
        return path;
    }

    public static String convertPath2FilePathString(String path) {
        path = URIUtil.addFilePrefix(path);
        return path.replaceAll(" ", "%20").replaceAll("\\\\", "/");
    }

    public static String pathFromFileURI(URI uri) {
        return URIUtil.pathFromFileURI(uri.getPath());
    }

    public static String pathFromFileURI(String uri) {
        return URLDecoder.decode(URIUtil.processDecodedPart(URIUtil.stripFilePrefix(uri)), StandardCharsets.UTF_8);
    }

    private static String processDecodedPart(String path) {
        if (path.charAt(0) != '/') {
            return path;
        }
        String p = URIUtil.removeLocalhost(URIUtil.removeLeadingSlashes(path));
        return URIUtil.getPossibleDriveLetter(p).map(driveLetter -> "%s:\\%s".formatted(driveLetter, URIUtil.slashToBackslash(URIUtil.removeDriveLetterAndSlash(p)))).orElseGet(() -> "/" + p);
    }

    static String removeDriveLetterAndSlash(String path) {
        return path.replaceFirst("\\w[:?|/]/*", "");
    }

    static String slashToBackslash(String path) {
        return path.replace('/', '\\');
    }

    static String removeLocalhost(String s) {
        if (s.startsWith("localhost")) {
            return s.substring(10);
        }
        return s;
    }

    static String removeLeadingSlashes(String s) {
        return s.replaceAll("^/*", "");
    }

    static Optional<String> getPossibleDriveLetter(String p) {
        Matcher m = driveLetterPattern.matcher(p);
        if (m.matches()) {
            return Optional.of(m.group(1));
        }
        return Optional.empty();
    }

    private static String stripFilePrefix(String uri) {
        if (!uri.startsWith("file:")) {
            return uri;
        }
        return uri.substring(5);
    }

    public static String normalizeSingleDot(String uri) {
        if (!uri.contains("/./")) {
            return uri;
        }
        StringBuilder sb = new StringBuilder(uri.length());
        block4: for (int i = 0; i < uri.length(); ++i) {
            int c = uri.codePointAt(i);
            switch (c) {
                case 63: {
                    sb.append(uri.substring(i));
                    return sb.toString();
                }
                case 47: {
                    sb.appendCodePoint(c);
                    while (i < uri.length() - 2 && uri.codePointAt(i + 1) == 46 && uri.codePointAt(i + 2) == 47) {
                        i += 2;
                    }
                    continue block4;
                }
                default: {
                    sb.appendCodePoint(c);
                }
            }
        }
        return sb.toString();
    }
}

