/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.predic8.membrane.core.http.Response;
import jakarta.mail.internet.ParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);
    private static Method newVirtualThreadPerTaskExecutor;
    private static final AtomicBoolean loggedVirtualThreads;

    public static int lineCount(String s) {
        return s.split("\n").length;
    }

    public static void shutdownOutput(Socket socket) throws IOException {
        if (!(socket instanceof SSLSocket || socket.isClosed() || socket.isOutputShutdown())) {
            socket.shutdownOutput();
        }
    }

    public static void shutdownInput(Socket socket) throws IOException {
        if (!(socket instanceof SSLSocket || socket.isClosed() || socket.isInputShutdown())) {
            socket.shutdownInput();
        }
    }

    public static HashMap<String, String> parseSimpleJSONResponse(Response g) throws IOException, ParseException {
        HashMap<String, String> values = new HashMap<String, String>();
        if (g.getHeader().getContentType() != null && g.getHeader().getContentTypeObject().match("application/json")) {
            JsonParser jp = new JsonFactory().createParser((Reader)new InputStreamReader(g.getBodyAsStreamDecoded()));
            String name = null;
            while (jp.nextToken() != null) {
                switch (jp.getCurrentToken()) {
                    case FIELD_NAME: {
                        name = jp.getCurrentName();
                        break;
                    }
                    case VALUE_STRING: {
                        values.put(name, jp.getText());
                        break;
                    }
                    case VALUE_NUMBER_INT: {
                        values.put(name, "" + jp.getLongValue());
                    }
                }
            }
        }
        return values;
    }

    public static ExecutorService createNewThreadPool() {
        if (newVirtualThreadPerTaskExecutor != null) {
            try {
                ExecutorService executorService = (ExecutorService)newVirtualThreadPerTaskExecutor.invoke(null, new Object[0]);
                if (loggedVirtualThreads.compareAndSet(false, true)) {
                    LOG.info("Using virtual threads. (Use -Dmembrane.virtualthreads=false to disable.)");
                }
                return executorService;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof UnsupportedOperationException) {
                    LOG.warn("Using traditional threads instead of virtual threads. Use the JVM option --enable-preview to enable virtual threads. (Or use -Dmembrane.virtualthreads=false to disable this warning.)");
                    newVirtualThreadPerTaskExecutor = null;
                }
                throw new RuntimeException(e);
            }
        }
        return Executors.newCachedThreadPool();
    }

    public static List<String> splitStringByComma(String string) {
        return new ArrayList<String>(Arrays.asList(string.split(",")));
    }

    static {
        loggedVirtualThreads = new AtomicBoolean();
        try {
            if (!"false".equals(System.getProperty("membrane.virtualthreads"))) {
                newVirtualThreadPerTaskExecutor = Executors.class.getMethod("newVirtualThreadPerTaskExecutor", new Class[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

