/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.util.XMLUtil;
import com.predic8.wsdl.AbstractPortTypeMessage;
import com.predic8.wsdl.Definitions;
import com.predic8.wsdl.Operation;
import com.predic8.wsdl.Port;
import com.predic8.wsdl.PortType;
import com.predic8.wsdl.Service;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSDLUtil {
    static Logger log = LoggerFactory.getLogger((String)WSDLUtil.class.getName());

    public static Service getService(Definitions definitions, String serviceName) {
        List<Service> services = definitions.getServices().stream().filter(s -> s.getName().equals(serviceName)).toList();
        if (services.isEmpty()) {
            String msg = "No service found with name %s in WSDL with namespace %s".formatted(serviceName, definitions.getTargetNamespace());
            log.error(msg);
            throw new RuntimeException(msg);
        }
        return services.get(0);
    }

    public static Set<PortType> getPortTypes(Service service) {
        HashSet<PortType> portTypes = new HashSet<PortType>();
        service.getPorts().forEach(port -> portTypes.add(port.getBinding().getPortType()));
        return portTypes;
    }

    public static Set<QName> getPossibleSOAPElements(Service service, Direction direction) {
        return WSDLUtil.getPossibleSOAPElements(((Port)service.getPorts().get(0)).getBinding().getPortType(), direction);
    }

    public static Set<QName> getPossibleSOAPElements(PortType portType, Direction direction) {
        HashSet<QName> elements = new HashSet<QName>();
        portType.getOperations().forEach(op -> {
            AbstractPortTypeMessage msg = WSDLUtil.getMessage(direction, op);
            if (msg == null) {
                return;
            }
            msg.getMessage().getParts().forEach(part -> elements.add(XMLUtil.groovyToJavaxQName(part.getElement().getQname())));
        });
        return elements;
    }

    public static Constants.SoapVersion getSOAPVersion(Port port) {
        Object object = port.getAddress().getElementName();
        if (object instanceof QName) {
            QName qn = (QName)object;
            return switch (qn.getNamespaceURI()) {
                case "http://schemas.xmlsoap.org/wsdl/soap/" -> Constants.SoapVersion.SOAP11;
                case "http://schemas.xmlsoap.org/wsdl/soap12/" -> Constants.SoapVersion.SOAP12;
                default -> Constants.SoapVersion.UNKNOWN;
            };
        }
        return Constants.SoapVersion.UNKNOWN;
    }

    private static AbstractPortTypeMessage getMessage(Direction direction, Operation operation) {
        if (direction == Direction.REQUEST) {
            return operation.getInput();
        }
        return operation.getOutput();
    }

    public static enum Direction {
        REQUEST,
        RESPONSE;

    }
}

