/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.http.Message;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLUtil {
    public static String xml2string(Node doc) throws TransformerException {
        TransformerFactory tfFactory = TransformerFactory.newInstance();
        Transformer tf = tfFactory.newTransformer();
        tf.setOutputProperty("omit-xml-declaration", "yes");
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StringWriter writer = new StringWriter();
        tf.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.toString();
    }

    public static QName groovyToJavaxQName(groovy.namespace.QName qName) {
        return new QName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix());
    }

    @NotNull
    public static InputSource getInputSource(Message msg) {
        return new InputSource(new InputStreamReader(msg.getBodyAsStreamDecoded()));
    }

    public static void mapToXml(Document doc, Element parent, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Element elem = doc.createElement(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof Map) {
                XMLUtil.mapToXml(doc, elem, (Map)value);
            } else if (value instanceof List) {
                for (Object item : (List)value) {
                    Element itemElement = doc.createElement("item");
                    if (item instanceof Map) {
                        XMLUtil.mapToXml(doc, itemElement, (Map)item);
                    } else {
                        itemElement.setTextContent(item.toString());
                    }
                    elem.appendChild(itemElement);
                }
            } else {
                elem.setTextContent(value.toString());
            }
            parent.appendChild(elem);
        }
    }
}

