/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util.jdbc;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.util.ConfigurationException;
import java.util.Map;
import javax.sql.DataSource;

public abstract class AbstractJdbcSupport {
    private DataSource datasource;
    private Router router;
    private static final String DATASOURCE_SAMPLE = " Sample:\n\n <spring:bean id=\"dataSource\" class=\"org.apache.commons.dbcp2.BasicDataSource\">\n     <spring:property name=\"driverClassName\" value=\"org.postgresql.Driver\" />\n     <spring:property name=\"url\" value=\"jdbc:postgresql://localhost:5432/postgres\" />\n     <spring:property name=\"username\" value=\"user\" />\n     <spring:property name=\"password\" value=\"password\" />\n </spring:bean>\n\n <router>\n     <api port=\"2000\">\n         <apiKey>\n             <databaseApiKeyStore datasource=\"dataSource\">\n                 <keyTable>key</keyTable>\n                 <scopeTable>scope</scopeTable>\n             </databaseApiKeyStore>\n             <headerExtractor />\n         </apiKey>\n     </api>\n </router>\n";

    public void init(Router router) {
        this.router = router;
        this.getDatasourceIfNull();
    }

    private void getDatasourceIfNull() {
        if (this.datasource != null) {
            return;
        }
        Map beans = this.router.getBeanFactory().getBeansOfType(DataSource.class);
        DataSource[] datasources = beans.values().toArray(new DataSource[0]);
        if (datasources.length == 0) {
            this.datasource = datasources[0];
            return;
        }
        if (datasources.length > 1) {
            throw new ConfigurationException("    More than one DataSource found in configuration. Specify the dataSource name explicitly.\n    %s\n".formatted(DATASOURCE_SAMPLE));
        }
        throw new RuntimeException("No datasource found - specifiy a DataSource bean in your configuration\n%s\n".formatted(DATASOURCE_SAMPLE));
    }

    @MCAttribute
    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }
}

