/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util.xml;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListWrapper
implements NodeList {
    NodeList nodeList;

    public NodeListWrapper(NodeList nodeList) {
        this.nodeList = nodeList;
    }

    @Override
    public Node item(int index) {
        return this.nodeList.item(index);
    }

    @Override
    public int getLength() {
        return this.nodeList.getLength();
    }

    public String toString() {
        return NodeListWrapper.nodeListToPlainText(this.nodeList);
    }

    public static String nodeListToPlainText(NodeList nodeList) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NodeListWrapper.appendTextNodeContent(node, builder);
        }
        return builder.toString().trim();
    }

    private static void appendTextNodeContent(Node node, StringBuilder builder) {
        if (node.getNodeType() == 3) {
            String textContent = node.getTextContent().trim();
            if (!textContent.isEmpty()) {
                builder.append(textContent).append(" ");
            }
        } else if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                NodeListWrapper.appendTextNodeContent(children.item(i), builder);
            }
        }
    }
}

