/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.ws.relocator;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class Relocator {
    private static final Logger log = LoggerFactory.getLogger((String)Relocator.class.getName());
    private final XMLEventFactory fac = XMLEventFactory.newInstance();
    private final String host;
    private final int port;
    private final String contextPath;
    private final String protocol;
    private final XMLEventWriter writer;
    private final PathRewriter pathRewriter;
    private Map<QName, String> relocatingAttributes = new HashMap<QName, String>();
    private boolean wsdlFound;

    public Relocator(Writer w, String protocol, String host, int port, String contextPath, PathRewriter pathRewriter) throws Exception {
        this.writer = XMLOutputFactory.newInstance().createXMLEventWriter(w);
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.contextPath = contextPath;
        this.pathRewriter = pathRewriter;
    }

    public Relocator(OutputStreamWriter osw, String protocol, String host, int port, String contextPath, PathRewriter pathRewriter) throws Exception {
        this.writer = XMLOutputFactory.newInstance().createXMLEventWriter(osw);
        this.host = host;
        this.port = port;
        this.protocol = protocol;
        this.contextPath = contextPath;
        this.pathRewriter = pathRewriter;
    }

    public void relocate(InputStreamReader isr) throws Exception {
        XMLEventReader parser = XMLInputFactory.newInstance().createXMLEventReader(isr);
        while (parser.hasNext()) {
            this.writer.add(this.getEvent(parser));
        }
        this.writer.flush();
    }

    private XMLEvent getEvent(XMLEventReader parser) throws XMLStreamException {
        XMLEvent event = parser.nextEvent();
        if (!event.isStartElement()) {
            return event;
        }
        if (this.getElementName(event).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/") || this.getElementName(event).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/")) {
            this.wsdlFound = true;
        }
        return this.relocatingAttributes.entrySet().stream().filter(e -> this.getElementName(event).equals(e.getKey())).findFirst().map(e -> this.replace(event, (String)e.getValue())).orElse(event);
    }

    private QName getElementName(XMLEvent event) {
        return event.asStartElement().getName();
    }

    private XMLEvent replace(XMLEvent event, String attribute) {
        StartElement start = event.asStartElement();
        return this.fac.createStartElement(start.getName(), new ReplaceIterator(this.fac, attribute, start.getAttributes()), start.getNamespaces());
    }

    public boolean isWsdlFound() {
        return this.wsdlFound;
    }

    public static String getNewLocation(String addr, String protocol, String host, int port, String contextPath) {
        try {
            URL oldURL = new URL(addr);
            if (port == -1) {
                return new URL(protocol, host, contextPath + oldURL.getFile()).toString();
            }
            if ("http".equals(protocol) && port == 80) {
                port = -1;
            }
            if ("https".equals(protocol) && port == 443) {
                port = -1;
            }
            return new URL(protocol, host, port, contextPath + oldURL.getFile()).toString();
        }
        catch (MalformedURLException e) {
            log.error("", (Throwable)e);
            return "";
        }
    }

    public Map<QName, String> getRelocatingAttributes() {
        return this.relocatingAttributes;
    }

    public void setRelocatingAttributes(Map<QName, String> relocatingAttributes) {
        this.relocatingAttributes = relocatingAttributes;
    }

    public static interface PathRewriter {
        public String rewrite(String var1);
    }

    private class ReplaceIterator
    implements Iterator<Attribute> {
        private final XMLEventFactory fac;
        private final Iterator<Attribute> attrs;
        private final String replace;

        public ReplaceIterator(XMLEventFactory fac, String replace, Iterator<Attribute> attrs) {
            this.fac = fac;
            this.replace = replace;
            this.attrs = attrs;
        }

        @Override
        public boolean hasNext() {
            return this.attrs.hasNext();
        }

        @Override
        public Attribute next() {
            Attribute atr = this.attrs.next();
            if (atr.getName().equals(new QName(this.replace))) {
                String value = atr.getValue();
                if (Relocator.this.pathRewriter != null) {
                    if ((value = Relocator.this.pathRewriter.rewrite(value)).startsWith("http")) {
                        return this.fac.createAttribute(this.replace, Relocator.getNewLocation(value, Relocator.this.protocol, Relocator.this.host, Relocator.this.port, Relocator.this.contextPath));
                    }
                    return this.fac.createAttribute(this.replace, value);
                }
                if (value.startsWith("http")) {
                    return this.fac.createAttribute(this.replace, Relocator.getNewLocation(value, Relocator.this.protocol, Relocator.this.host, Relocator.this.port, Relocator.this.contextPath));
                }
            }
            return atr;
        }

        @Override
        public void remove() {
            this.attrs.remove();
        }
    }
}

