/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.dec;

import java.nio.ByteBuffer;
import org.brotli.dec.BrotliRuntimeException;
import org.brotli.dec.Utils;

public final class Dictionary {
    static final int MIN_DICTIONARY_WORD_LENGTH = 4;
    static final int MAX_DICTIONARY_WORD_LENGTH = 31;
    private static ByteBuffer data = ByteBuffer.allocateDirect(0);
    static final int[] offsets = new int[32];
    static final int[] sizeBits = new int[32];

    public static void setData(ByteBuffer newData, int[] newSizeBits) {
        int i;
        if (Utils.isDirect(newData) == 0 || Utils.isReadOnly(newData) == 0) {
            throw new BrotliRuntimeException("newData must be a direct read-only byte buffer");
        }
        if (newSizeBits.length > 31) {
            throw new BrotliRuntimeException("sizeBits length must be at most " + String.valueOf(31));
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            if (newSizeBits[i2] == 0) continue;
            throw new BrotliRuntimeException("first " + String.valueOf(4) + " must be 0");
        }
        int[] dictionaryOffsets = offsets;
        int[] dictionarySizeBits = sizeBits;
        System.arraycopy(newSizeBits, 0, dictionarySizeBits, 0, newSizeBits.length);
        int pos = 0;
        int limit = newData.capacity();
        for (i = 0; i < newSizeBits.length; ++i) {
            dictionaryOffsets[i] = pos;
            int bits = dictionarySizeBits[i];
            if (bits == 0) continue;
            if (bits >= 31) {
                throw new BrotliRuntimeException("newSizeBits values must be less than 31");
            }
            if ((pos += i << bits) > 0 && pos <= limit) continue;
            throw new BrotliRuntimeException("newSizeBits is inconsistent: overflow");
        }
        for (i = newSizeBits.length; i < 32; ++i) {
            dictionaryOffsets[i] = pos;
        }
        if (pos != limit) {
            throw new BrotliRuntimeException("newSizeBits is inconsistent: underflow");
        }
        data = newData;
    }

    public static ByteBuffer getData() {
        if (data.capacity() != 0) {
            return data;
        }
        if (!DataLoader.OK) {
            throw new BrotliRuntimeException("brotli dictionary is not set");
        }
        return data;
    }

    private static class DataLoader {
        static final boolean OK;

        private DataLoader() {
        }

        static {
            boolean ok = true;
            try {
                Class.forName(Dictionary.class.getPackage().getName() + ".DictionaryData");
            }
            catch (Throwable ex) {
                ok = false;
            }
            OK = ok;
        }
    }
}

