/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formeta;

import org.metafacture.formeta.formatter.Formatter;
import org.metafacture.formeta.formatter.FormatterStyle;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@Description(value="Encodes streams in formeta format.")
@In(value=StreamReceiver.class)
@Out(value=String.class)
@FluxCommand(value="encode-formeta")
public final class FormetaEncoder
extends DefaultStreamPipe<ObjectReceiver<String>> {
    private FormatterStyle style = FormatterStyle.CONCISE;
    private Formatter formatter = this.style.createFormatter();

    public FormatterStyle getStyle() {
        return this.style;
    }

    public void setStyle(FormatterStyle formatterStyle) {
        this.style = formatterStyle;
        this.formatter = formatterStyle.createFormatter();
    }

    public void startRecord(String identifier) {
        this.formatter.reset();
        this.formatter.startGroup(identifier);
    }

    public void endRecord() {
        this.formatter.endGroup();
        ((ObjectReceiver)this.getReceiver()).process((Object)this.formatter.toString());
    }

    public void startEntity(String name) {
        this.formatter.startGroup(name);
    }

    public void endEntity() {
        this.formatter.endGroup();
    }

    public void literal(String name, String value) {
        this.formatter.literal(name, value);
    }
}

