/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formeta.formatter;

import org.metafacture.formeta.formatter.AbstractFormatter;

public final class MultilineFormatter
extends AbstractFormatter {
    public static final String INDENT = "\t";
    private static final String GROUP_START = " {";
    private static final String NAME_VALUE_SEPARATOR = ": ";
    private final StringBuilder indent = new StringBuilder();
    private boolean appendItemSeparator;
    private boolean firstItem;

    public MultilineFormatter() {
        this.onReset();
    }

    @Override
    public void startGroup(String name) {
        if (this.appendItemSeparator) {
            this.append(',');
        }
        if (!this.firstItem) {
            this.append(this.indent);
        }
        this.escapeAndAppend(name);
        this.append(GROUP_START);
        this.indent.append(INDENT);
        this.appendItemSeparator = false;
        this.firstItem = false;
    }

    @Override
    public void endGroup() {
        this.indent.delete(this.indent.length() - INDENT.length(), this.indent.length());
        this.append(this.indent);
        this.append('}');
        this.appendItemSeparator = true;
    }

    @Override
    public void literal(String name, String value) {
        if (this.appendItemSeparator) {
            this.append(',');
        }
        if (!this.firstItem) {
            this.append(this.indent);
        }
        this.escapeAndAppend(name);
        this.append(NAME_VALUE_SEPARATOR);
        this.escapeAndAppend(value);
        this.appendItemSeparator = true;
        this.firstItem = false;
    }

    @Override
    protected void onReset() {
        this.indent.delete(0, this.indent.length());
        this.indent.append('\n');
        this.appendItemSeparator = false;
        this.firstItem = true;
    }

    @Override
    protected boolean shouldQuoteText(char[] buffer, int len) {
        return true;
    }
}

