/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formeta.formatter;

import org.metafacture.formeta.formatter.AbstractFormatter;

public final class VerboseFormatter
extends AbstractFormatter {
    private static final String GROUP_START = "{ ";
    private static final String GROUP_END = " }";
    private static final String ITEM_SEPARATOR = ", ";
    private static final String NAME_VALUE_SEPARATOR = ": ";
    private boolean appendItemSeparator;

    @Override
    public void startGroup(String name) {
        if (this.appendItemSeparator) {
            this.append(ITEM_SEPARATOR);
        }
        this.escapeAndAppend(name);
        this.append(GROUP_START);
        this.appendItemSeparator = false;
    }

    @Override
    public void endGroup() {
        this.append(GROUP_END);
        this.appendItemSeparator = true;
    }

    @Override
    public void literal(String name, String value) {
        if (this.appendItemSeparator) {
            this.append(ITEM_SEPARATOR);
        }
        this.escapeAndAppend(name);
        this.append(NAME_VALUE_SEPARATOR);
        this.escapeAndAppend(value);
        this.appendItemSeparator = true;
    }

    @Override
    protected void onReset() {
        this.appendItemSeparator = false;
    }

    @Override
    protected boolean shouldQuoteText(char[] buffer, int len) {
        String triggerChars = "\t\n\r \n\r'\\{},:";
        for (int i = 0; i < len; ++i) {
            if ("\t\n\r \n\r'\\{},:".indexOf(buffer[i]) <= -1) continue;
            return true;
        }
        return len == 0;
    }
}

