/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formeta.parser;

import org.metafacture.commons.StringUtil;
import org.metafacture.formeta.parser.Emitter;
import org.metafacture.formeta.parser.StructureParserContext;
import org.metafacture.formeta.parser.StructureParserState;
import org.metafacture.framework.FormatException;

public final class FormetaParser {
    public static final int SNIPPET_SIZE = 20;
    public static final String SNIPPET_ELLIPSIS = "\u2026";
    public static final String POS_MARKER_LEFT = ">";
    public static final String POS_MARKER_RIGHT = "<";
    private static final int BUFFER_SIZE = 0x100000;
    private char[] buffer = new char[0x100000];
    private final StructureParserContext structureParserContext = new StructureParserContext();

    public void setEmitter(Emitter emitter) {
        this.structureParserContext.setEmitter(emitter);
    }

    public Emitter getEmitter() {
        return this.structureParserContext.getEmitter();
    }

    public void parse(String data) {
        int i;
        assert (this.structureParserContext.getEmitter() != null) : "No emitter set";
        this.buffer = StringUtil.copyToBuffer((String)data, (char[])this.buffer);
        int bufferLen = data.length();
        this.structureParserContext.reset();
        StructureParserState state = StructureParserState.ITEM_NAME;
        try {
            for (i = 0; i < bufferLen; ++i) {
                state = state.processChar(this.buffer[i], this.structureParserContext);
            }
        }
        catch (FormatException e) {
            String errorMsg = "Parsing error at position " + (i + 1) + ": " + FormetaParser.getErrorSnippet(data, i) + ", " + e.getMessage();
            throw new FormatException(errorMsg, (Throwable)e);
        }
        try {
            state.endOfInput(this.structureParserContext);
        }
        catch (FormatException e) {
            throw new FormatException("Parsing error: " + e.getMessage(), (Throwable)e);
        }
    }

    private static String getErrorSnippet(String record, int pos) {
        StringBuilder snippet = new StringBuilder();
        int start = pos - 10;
        if (start < 0) {
            snippet.append(record.substring(0, pos));
        } else {
            snippet.append(SNIPPET_ELLIPSIS);
            snippet.append(record.substring(start, pos));
        }
        snippet.append(POS_MARKER_LEFT);
        snippet.append(record.charAt(pos));
        snippet.append(POS_MARKER_RIGHT);
        if (pos + 1 < record.length()) {
            int end = pos + 10;
            if (end > record.length()) {
                snippet.append(record.substring(pos + 1));
            } else {
                snippet.append(record.substring(pos + 1, end));
                snippet.append(SNIPPET_ELLIPSIS);
            }
        }
        return snippet.toString();
    }
}

