/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.formeta.parser;

import org.metafacture.formeta.parser.Emitter;
import org.metafacture.formeta.parser.TextParserContext;
import org.metafacture.formeta.parser.TextParserState;

class StructureParserContext {
    private Emitter emitter;
    private final TextParserContext textParserContext = new TextParserContext();
    private TextParserState textParser = TextParserState.LEADING_WHITESPACE;
    private String parsedText = "";
    private String literalName;
    private int nestingLevel;

    StructureParserContext() {
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public boolean processCharWithTextParser(char ch) {
        this.textParser = this.textParser.processChar(ch, this.textParserContext);
        if (this.textParser == TextParserState.DELIMITER_REACHED) {
            this.parsedText = this.textParserContext.getText();
            this.textParser = TextParserState.LEADING_WHITESPACE;
            this.textParserContext.reset();
            return true;
        }
        return false;
    }

    public void processEOIWithTextParser() {
        this.textParser.endOfInput(this.textParserContext);
        this.parsedText = this.textParserContext.getText();
        this.textParser = TextParserState.LEADING_WHITESPACE;
        this.textParserContext.reset();
    }

    public void startGroup() {
        this.emitter.startGroup(this.parsedText, this.nestingLevel);
        ++this.nestingLevel;
    }

    public void endGroup() {
        --this.nestingLevel;
        this.emitter.endGroup(this.nestingLevel);
    }

    public void startLiteral() {
        this.literalName = this.parsedText;
    }

    public void endLiteral() {
        this.emitter.literal(this.literalName, this.parsedText, this.nestingLevel);
        this.literalName = null;
    }

    public boolean isTextEmpty() {
        return this.parsedText.isEmpty();
    }

    public boolean isNested() {
        return this.nestingLevel > 0;
    }

    public void reset() {
        this.textParser = TextParserState.LEADING_WHITESPACE;
        this.textParserContext.reset();
        this.parsedText = "";
        this.literalName = null;
        this.nestingLevel = 0;
    }
}

