/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.json.JsonEncoder;

@Description(value="Decodes JSON to metadata events. The 'recordPath' option can be used to set a JsonPath to extract a path as JSON - or to split the data into multiple JSON documents.")
@In(value=String.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="decode-json")
public final class JsonDecoder
extends DefaultObjectPipe<String, StreamReceiver> {
    public static final String DEFAULT_ARRAY_MARKER = "[]";
    public static final String DEFAULT_BOOLEAN_MARKER = JsonEncoder.BOOLEAN_MARKER;
    public static final String DEFAULT_NUMBER_MARKER = JsonEncoder.NUMBER_MARKER;
    public static final String DEFAULT_ARRAY_NAME = "%d";
    public static final String DEFAULT_RECORD_ID = "%d";
    public static final String DEFAULT_ROOT_PATH = "";
    private final JsonFactory jsonFactory = new JsonFactory();
    private JsonParser jsonParser;
    private String arrayMarker = "[]";
    private String arrayName = "%d";
    private String booleanMarker = DEFAULT_BOOLEAN_MARKER;
    private String numberMarker = DEFAULT_NUMBER_MARKER;
    private String recordId = "%d";
    private String recordPath = "";
    private int recordCount;

    public void setAllowComments(boolean allowComments) {
        this.jsonFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, allowComments);
    }

    public boolean getAllowComments() {
        return this.jsonFactory.isEnabled(JsonParser.Feature.ALLOW_COMMENTS);
    }

    public void setArrayMarker(String arrayMarker) {
        this.arrayMarker = arrayMarker;
    }

    public String getArrayMarker() {
        return this.arrayMarker;
    }

    public void setBooleanMarker(String booleanMarker) {
        this.booleanMarker = booleanMarker;
    }

    public String getBooleanMarker() {
        return this.booleanMarker;
    }

    public void setNumberMarker(String numberMarker) {
        this.numberMarker = numberMarker;
    }

    public String getNumberMarker() {
        return this.numberMarker;
    }

    public void setArrayName(String arrayName) {
        this.arrayName = arrayName;
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordPath(String recordPath) {
        this.recordPath = recordPath;
    }

    public String getRecordPath() {
        return this.recordPath;
    }

    public void resetRecordCount() {
        this.setRecordCount(0);
    }

    public void process(String json) {
        assert (!this.isClosed());
        if (this.recordPath.isEmpty()) {
            this.processRecord(json);
        } else {
            this.matches(JsonPath.read((String)json, (String)this.recordPath, (Predicate[])new Predicate[0])).forEach(record -> this.processRecord((String)record));
        }
    }

    private void processRecord(String record) {
        this.createParser(record);
        try {
            this.decode();
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
        finally {
            this.closeParser();
        }
    }

    private Stream<String> matches(Object obj) {
        List<Object> records = obj instanceof List ? (List<Object>)obj : Arrays.asList(obj);
        return records.stream().map(doc -> {
            try {
                return new ObjectMapper().writeValueAsString(doc);
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return doc.toString();
            }
        });
    }

    protected void onResetStream() {
        this.resetRecordCount();
    }

    private void createParser(String string) {
        try {
            this.jsonParser = this.jsonFactory.createParser(string);
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private void closeParser() {
        try {
            this.jsonParser.close();
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private void decode() throws IOException {
        while (this.jsonParser.nextToken() == JsonToken.START_OBJECT) {
            ((StreamReceiver)this.getReceiver()).startRecord(String.format(this.recordId, ++this.recordCount));
            this.decodeObject();
            ((StreamReceiver)this.getReceiver()).endRecord();
        }
        if (this.jsonParser.currentToken() != null) {
            throw new MetafactureException("Unexpected token '" + this.jsonParser.currentToken() + "' at " + this.jsonParser.getCurrentLocation());
        }
    }

    private void decodeObject() throws IOException {
        while (this.jsonParser.nextToken() == JsonToken.FIELD_NAME) {
            this.decodeValue(this.jsonParser.getCurrentName(), this.jsonParser.nextToken());
        }
    }

    private void decodeArray() throws IOException {
        int arrayCount = 0;
        while (this.jsonParser.nextToken() != JsonToken.END_ARRAY) {
            this.decodeValue(String.format(this.arrayName, ++arrayCount), this.jsonParser.currentToken());
        }
    }

    private void decodeValue(String name, JsonToken token) throws IOException {
        switch (token) {
            case START_OBJECT: {
                ((StreamReceiver)this.getReceiver()).startEntity(name);
                this.decodeObject();
                ((StreamReceiver)this.getReceiver()).endEntity();
                break;
            }
            case START_ARRAY: {
                ((StreamReceiver)this.getReceiver()).startEntity(this.getMarkedName(name, this.arrayMarker));
                this.decodeArray();
                ((StreamReceiver)this.getReceiver()).endEntity();
                break;
            }
            case VALUE_NULL: {
                ((StreamReceiver)this.getReceiver()).literal(name, null);
                break;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                ((StreamReceiver)this.getReceiver()).literal(this.getMarkedName(name, this.booleanMarker), this.jsonParser.getText());
                break;
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                ((StreamReceiver)this.getReceiver()).literal(this.getMarkedName(name, this.numberMarker), this.jsonParser.getText());
                break;
            }
            default: {
                ((StreamReceiver)this.getReceiver()).literal(name, this.jsonParser.getText());
            }
        }
    }

    private String getMarkedName(String name, String marker) {
        return marker != null ? name + marker : name;
    }
}

