/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;

@Description(value="Serialises an object as JSON")
@In(value=StreamReceiver.class)
@Out(value=String.class)
@FluxCommand(value="encode-json")
public final class JsonEncoder
extends DefaultStreamPipe<ObjectReceiver<String>> {
    public static final String ARRAY_MARKER = "[]";
    public static final String BOOLEAN_MARKER = null;
    public static final String NUMBER_MARKER = null;
    private static final char ESCAPE_CHAR_LOW = ' ';
    private static final char ESCAPE_CHAR_HIGH = '\u007f';
    private final JsonGenerator jsonGenerator;
    private final StringWriter writer = new StringWriter();
    private String arrayMarker = "[]";
    private String booleanMarker = BOOLEAN_MARKER;
    private String numberMarker = NUMBER_MARKER;

    public JsonEncoder() {
        try {
            this.jsonGenerator = new JsonFactory().createGenerator((Writer)this.writer);
            this.jsonGenerator.setRootValueSeparator(null);
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    public void setArrayMarker(String arrayMarker) {
        this.arrayMarker = arrayMarker;
    }

    public String getArrayMarker() {
        return this.arrayMarker;
    }

    public void setBooleanMarker(String booleanMarker) {
        this.booleanMarker = booleanMarker;
    }

    public String getBooleanMarker() {
        return this.booleanMarker;
    }

    public void setNumberMarker(String numberMarker) {
        this.numberMarker = numberMarker;
    }

    public String getNumberMarker() {
        return this.numberMarker;
    }

    public void setPrettyPrinting(boolean prettyPrinting) {
        this.jsonGenerator.setPrettyPrinter((PrettyPrinter)(prettyPrinting ? new DefaultPrettyPrinter((SerializableString)null) : null));
    }

    public boolean getPrettyPrinting() {
        return this.jsonGenerator.getPrettyPrinter() != null;
    }

    public void setJavaScriptEscapeChars(final int[] escapeCharacters) {
        CharacterEscapes ce = new CharacterEscapes(){
            private static final long serialVersionUID = 1L;

            public int[] getEscapeCodesForAscii() {
                if (escapeCharacters == null) {
                    return CharacterEscapes.standardAsciiEscapesForJSON();
                }
                return escapeCharacters;
            }

            public SerializableString getEscapeSequence(int ch) {
                String jsEscaped = JsonEncoder.this.escapeChar((char)ch);
                return new SerializedString(jsEscaped);
            }
        };
        this.jsonGenerator.setCharacterEscapes(ce);
    }

    public void startRecord(String id) {
        StringBuffer buffer = this.writer.getBuffer();
        buffer.delete(0, buffer.length());
        this.startGroup(id);
    }

    public void endRecord() {
        this.endGroup();
        try {
            this.jsonGenerator.flush();
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
        ((ObjectReceiver)this.getReceiver()).process((Object)this.writer.toString());
    }

    public void startEntity(String name) {
        this.startGroup(name);
    }

    public void endEntity() {
        this.endGroup();
    }

    public void literal(String name, String value) {
        try {
            JsonStreamContext ctx = this.jsonGenerator.getOutputContext();
            if (ctx.inObject()) {
                this.jsonGenerator.writeFieldName(this.getUnmarkedName(name, this.booleanMarker, this.numberMarker));
            }
            if (value == null) {
                this.jsonGenerator.writeNull();
            } else if (this.isMarkedName(name, this.booleanMarker)) {
                this.jsonGenerator.writeBoolean(Boolean.parseBoolean(value));
            } else if (this.isMarkedName(name, this.numberMarker)) {
                this.jsonGenerator.writeNumber(value);
            } else {
                this.jsonGenerator.writeString(value);
            }
        }
        catch (JsonGenerationException e) {
            throw new MetafactureException((Throwable)e);
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private void startGroup(String name) {
        try {
            JsonStreamContext ctx = this.jsonGenerator.getOutputContext();
            if (this.isMarkedName(name, this.arrayMarker)) {
                if (ctx.inObject()) {
                    this.jsonGenerator.writeFieldName(this.getUnmarkedName(name, this.arrayMarker));
                }
                this.jsonGenerator.writeStartArray();
            } else {
                if (ctx.inObject()) {
                    this.jsonGenerator.writeFieldName(name);
                }
                this.jsonGenerator.writeStartObject();
            }
        }
        catch (JsonGenerationException e) {
            throw new MetafactureException((Throwable)e);
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private void endGroup() {
        try {
            JsonStreamContext ctx = this.jsonGenerator.getOutputContext();
            if (ctx.inObject()) {
                this.jsonGenerator.writeEndObject();
            } else if (ctx.inArray()) {
                this.jsonGenerator.writeEndArray();
            }
        }
        catch (JsonGenerationException e) {
            throw new MetafactureException((Throwable)e);
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private boolean isMarkedName(String name, String marker) {
        return marker != null && name.endsWith(marker);
    }

    private String getUnmarkedName(String name, String ... markers) {
        for (String marker : markers) {
            if (!this.isMarkedName(name, marker)) continue;
            return name.substring(0, name.length() - marker.length());
        }
        return name;
    }

    private String escapeChar(char ch) {
        String namedEscape = this.namedEscape(ch);
        return namedEscape != null ? namedEscape : (ch < ' ' || '\u007f' < ch ? this.unicodeEscape(ch) : Character.toString(ch));
    }

    private String namedEscape(char ch) {
        String result;
        switch (ch) {
            case '\b': {
                result = "\\b";
                break;
            }
            case '\n': {
                result = "\\n";
                break;
            }
            case '\t': {
                result = "\\t";
                break;
            }
            case '\f': {
                result = "\\f";
                break;
            }
            case '\r': {
                result = "\\r";
                break;
            }
            case '\'': {
                result = "\\'";
                break;
            }
            case '\\': {
                result = "\\\\";
                break;
            }
            case '\"': {
                result = "\\\"";
                break;
            }
            case '/': {
                result = "\\/";
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private String unicodeEscape(char ch) {
        return String.format("\\u%4H", Character.valueOf(ch)).replace(' ', '0');
    }
}

