/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.json;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Validate JSON against a given schema, send only valid input to the receiver. Pass the schema location to validate against. Write valid and/or invalid output to locations specified with `writeValid` and `writeInvalid`. Set the JSON key for the record ID value with `idKey` (for logging output, defaults to `id`).")
@In(value=String.class)
@Out(value=String.class)
@FluxCommand(value="validate-json")
public final class JsonValidator
extends DefaultObjectPipe<String, ObjectReceiver<String>> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonValidator.class);
    private static final String DEFAULT_ID_KEY = "id";
    private Schema schema;
    private long fail;
    private long success;
    private FileWriter writeInvalid;
    private FileWriter writeValid;
    private String idKey = "id";

    public JsonValidator(String url) {
        this.initSchema(url);
    }

    public void setWriteValid(String writeValid) {
        this.writeValid = this.fileWriter(writeValid);
    }

    public void setWriteInvalid(String writeInvalid) {
        this.writeInvalid = this.fileWriter(writeInvalid);
    }

    public void setIdKey(String idKey) {
        this.idKey = idKey;
    }

    public void process(String json) {
        try {
            this.validate(json, new JSONObject(json));
        }
        catch (JSONException e) {
            this.handleInvalid(json, null, e.getMessage());
        }
    }

    private void validate(String json, JSONObject object) {
        try {
            this.schema.validate((Object)object);
            ((ObjectReceiver)this.getReceiver()).process((Object)json);
            ++this.success;
            this.write(json, this.writeValid);
        }
        catch (ValidationException e) {
            this.handleInvalid(json, object, e.getAllMessages().toString());
        }
    }

    protected void onCloseStream() {
        this.close(this.writeInvalid);
        this.close(this.writeValid);
        LOG.debug("Success: {}, Fail: {}", (Object)this.success, (Object)this.fail);
        super.onCloseStream();
    }

    private void initSchema(String schemaUrl) {
        if (this.schema != null) {
            return;
        }
        SchemaLoader.SchemaLoaderBuilder schemaLoader = SchemaLoader.builder();
        try {
            URL url = new URL(schemaUrl);
            schemaLoader = schemaLoader.schemaJson(this.jsonFrom(url.openStream())).resolutionScope(this.baseFor(url.toString()));
        }
        catch (IOException e) {
            LOG.debug("Could not read as URL: {}, trying to load from class path", (Object)schemaUrl);
            schemaLoader = schemaLoader.schemaClient(SchemaClient.classPathAwareClient()).schemaJson(this.jsonFrom(((Object)((Object)this)).getClass().getResourceAsStream(schemaUrl))).resolutionScope("classpath://" + this.baseFor(schemaUrl));
        }
        this.schema = schemaLoader.build().load().build();
    }

    private JSONObject jsonFrom(InputStream inputStream) {
        try {
            return new JSONObject(new JSONTokener(inputStream));
        }
        catch (JSONException e) {
            throw new MetafactureException(e.getMessage(), (Throwable)e);
        }
    }

    private String baseFor(String path) {
        return path.substring(0, path.lastIndexOf(47) + 1);
    }

    private FileWriter fileWriter(String fileLocation) {
        try {
            return new FileWriter(fileLocation);
        }
        catch (IOException e) {
            throw new MetafactureException(e.getMessage(), (Throwable)e);
        }
    }

    private void handleInvalid(String json, JSONObject object, String errorMessage) {
        LOG.info("Invalid JSON: {} in {}", (Object)errorMessage, object != null ? object.opt(this.idKey) : json);
        ++this.fail;
        this.write(json, this.writeInvalid);
    }

    private void write(String json, FileWriter fileWriter) {
        if (fileWriter != null) {
            try {
                fileWriter.append(json);
                fileWriter.append("\n");
            }
            catch (IOException e) {
                throw new MetafactureException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void close(FileWriter fileWriter) {
        if (fileWriter != null) {
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                throw new MetafactureException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

