/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Function;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.framework.objects.Triple;
import org.metafacture.triples.MemoryWarningSystem;
import org.metafacture.triples.SortedTripleFileFacade;

public abstract class AbstractTripleSort
extends DefaultObjectPipe<Triple, ObjectReceiver<Triple>>
implements MemoryWarningSystem.Listener {
    private final List<Triple> buffer = new ArrayList<Triple>();
    private final List<File> tempFiles = new ArrayList<File>();
    private Compare compare = Compare.SUBJECT;
    private Order order = Order.INCREASING;
    private boolean numeric;
    private volatile boolean memoryLow;

    protected AbstractTripleSort() {
        MemoryWarningSystem.addListener(this);
    }

    @Override
    public final void memoryLow(long usedMemory, long maxMemory) {
        this.memoryLow = true;
    }

    protected final void setCompare(Compare compare) {
        this.compare = compare;
    }

    protected final Compare getCompare() {
        return this.compare;
    }

    protected final void setSortOrder(Order newOrder) {
        this.order = newOrder;
    }

    protected final void setSortNumeric(boolean newNumeric) {
        this.numeric = newNumeric;
    }

    public final void process(Triple namedValue) {
        if (this.memoryLow) {
            try {
                if (!this.buffer.isEmpty()) {
                    this.nextBatch();
                }
            }
            catch (IOException e) {
                throw new MetafactureException("Error writing to temp file after sorting", (Throwable)e);
            }
            finally {
                this.memoryLow = false;
            }
        }
        this.buffer.add(namedValue);
    }

    private void nextBatch() throws IOException {
        Collections.sort(this.buffer, this.createComparator());
        File tempFile = File.createTempFile("sort", "namedValues", null);
        tempFile.deleteOnExit();
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(tempFile));){
            for (Triple triple : this.buffer) {
                triple.write(out);
            }
        }
        this.buffer.clear();
        this.tempFiles.add(tempFile);
    }

    public final void onCloseStream() {
        if (this.tempFiles.isEmpty()) {
            Collections.sort(this.buffer, this.createComparator());
            for (Triple triple : this.buffer) {
                this.sortedTriple(triple);
            }
            this.onFinished();
        } else {
            Comparator<Triple> comparator = this.createComparator();
            PriorityQueue<Object> queue = new PriorityQueue<Object>(11, (o1, o2) -> comparator.compare(o1.peek(), o2.peek()));
            try {
                this.nextBatch();
                for (File file : this.tempFiles) {
                    queue.add(new SortedTripleFileFacade(file));
                }
                while (queue.size() > 0) {
                    SortedTripleFileFacade sortedFileFacade = (SortedTripleFileFacade)queue.poll();
                    Triple triple = sortedFileFacade.pop();
                    this.sortedTriple(triple);
                    if (sortedFileFacade.isEmpty()) {
                        sortedFileFacade.close();
                        continue;
                    }
                    queue.add(sortedFileFacade);
                }
                this.onFinished();
            }
            catch (IOException e) {
                throw new MetafactureException("Error merging temp files", (Throwable)e);
            }
            finally {
                for (SortedTripleFileFacade sortedTripleFileFacade : queue) {
                    sortedTripleFileFacade.close();
                }
            }
        }
        MemoryWarningSystem.removeListener(this);
    }

    protected void onFinished() {
    }

    protected abstract void sortedTriple(Triple var1);

    public final Comparator<Triple> createComparator() {
        return AbstractTripleSort.createComparator(this.compare, this.order, this.numeric);
    }

    public static Comparator<Triple> createComparator(Compare compare, Order order) {
        return AbstractTripleSort.createComparator(compare, order, false);
    }

    private static Comparator<Triple> createComparator(Compare compare, Order order, boolean numeric) {
        Function<Triple, String> tripleFunction;
        switch (compare) {
            case ALL: {
                return (o1, o2) -> order.order(o1.compareTo(o2));
            }
            case OBJECT: {
                tripleFunction = Triple::getObject;
                break;
            }
            case SUBJECT: {
                tripleFunction = Triple::getSubject;
                break;
            }
            default: {
                tripleFunction = Triple::getPredicate;
            }
        }
        Function<Triple, Integer> numericFunction = tripleFunction.andThen(Integer::valueOf);
        return numeric ? (o1, o2) -> order.order(((Integer)numericFunction.apply((Triple)o1)).compareTo((Integer)numericFunction.apply((Triple)o2))) : (o1, o2) -> order.order(((String)tripleFunction.apply((Triple)o1)).compareTo((String)tripleFunction.apply((Triple)o2)));
    }

    public final void onResetStream() {
        this.buffer.clear();
        for (File file : this.tempFiles) {
            if (!file.exists()) continue;
            file.delete();
        }
        this.tempFiles.clear();
    }

    public static enum Order {
        INCREASING{

            @Override
            public int order(int indicator) {
                return indicator;
            }
        }
        ,
        DECREASING{

            @Override
            public int order(int indicator) {
                return -indicator;
            }
        };


        public abstract int order(int var1);
    }

    public static enum Compare {
        SUBJECT,
        PREDICATE,
        OBJECT,
        ALL;

    }
}

