/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metafacture.formeta.formatter.ConciseFormatter;
import org.metafacture.formeta.formatter.Formatter;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultStreamPipe;
import org.metafacture.framework.objects.Triple;

@Description(value="Emits the literals which are received as triples such that the name and value become the predicate and the object of the triple. The record id containing the literal becomes the subject. If 'redirect' is true, the value of the subject is determined by using either the value of a literal named '_id', or for individual literals by prefixing their name with '{to:ID}'. Set 'recordPredicate' to encode a complete record in one triple. The value of 'recordPredicate' is used as the predicate of the triple. If 'recordPredicate' is set, no {to:ID}NAME-style redirects are possible.")
@In(value=StreamReceiver.class)
@Out(value=Triple.class)
@FluxCommand(value="stream-to-triples")
public final class StreamToTriples
extends DefaultStreamPipe<ObjectReceiver<Triple>> {
    private static final Pattern REDIRECT_PATTERN = Pattern.compile("^\\{to:(.+)}(.+)$");
    private final List<String> nameBuffer = new ArrayList<String>();
    private final List<String> valueBuffer = new ArrayList<String>();
    private final List<Triple.ObjectType> typeBuffer = new ArrayList<Triple.ObjectType>();
    private final Formatter formatter = new ConciseFormatter();
    private boolean redirect;
    private String recordPredicate;
    private int nestingLevel;
    private int encodeLevel;
    private String predicateName;
    private String currentId;

    public boolean isRedirect() {
        return this.redirect;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public String getRecordPredicate() {
        return this.recordPredicate;
    }

    public void setRecordPredicate(String recordPredicate) {
        this.recordPredicate = recordPredicate;
    }

    public void startRecord(String identifier) {
        assert (!this.isClosed());
        this.currentId = identifier;
        if (this.recordPredicate != null) {
            this.encodeLevel = 0;
            this.startEncode(this.recordPredicate);
        } else {
            this.encodeLevel = 1;
        }
        this.nestingLevel = 1;
    }

    public void endRecord() {
        assert (!this.isClosed());
        this.nestingLevel = 0;
        if (this.nestingLevel == this.encodeLevel) {
            this.endEncode();
        }
        if (this.redirect) {
            for (int i = 0; i < this.nameBuffer.size(); ++i) {
                ((ObjectReceiver)this.getReceiver()).process((Object)new Triple(this.currentId, this.nameBuffer.get(i), this.valueBuffer.get(i), this.typeBuffer.get(i)));
            }
            this.nameBuffer.clear();
            this.valueBuffer.clear();
            this.typeBuffer.clear();
        }
    }

    public void startEntity(String name) {
        assert (!this.isClosed());
        if (this.nestingLevel > this.encodeLevel) {
            this.formatter.startGroup(name);
        } else {
            this.startEncode(name);
        }
        ++this.nestingLevel;
    }

    public void endEntity() {
        assert (!this.isClosed());
        --this.nestingLevel;
        if (this.nestingLevel == this.encodeLevel) {
            this.endEncode();
        } else {
            this.formatter.endGroup();
        }
    }

    public void literal(String name, String value) {
        assert (!this.isClosed());
        if (this.nestingLevel > this.encodeLevel) {
            if (this.nestingLevel == 1 && this.redirect && "_id".equals(name)) {
                this.currentId = value;
            } else {
                this.formatter.literal(name, value);
            }
        } else {
            this.dispatch(name, value, Triple.ObjectType.STRING);
        }
    }

    private void startEncode(String predicate) {
        this.predicateName = predicate;
        this.formatter.reset();
        this.formatter.startGroup("");
    }

    private void endEncode() {
        this.formatter.endGroup();
        this.dispatch(this.predicateName, this.formatter.toString(), Triple.ObjectType.ENTITY);
    }

    private void dispatch(String name, String value, Triple.ObjectType type) {
        if (this.redirect) {
            if ("_id".equals(name)) {
                this.currentId = value;
            } else {
                Matcher matcher = REDIRECT_PATTERN.matcher(name);
                if (matcher.find()) {
                    ((ObjectReceiver)this.getReceiver()).process((Object)new Triple(matcher.group(1), matcher.group(2), value, type));
                } else {
                    this.nameBuffer.add(name);
                    this.valueBuffer.add(value);
                    this.typeBuffer.add(type);
                }
            }
        } else {
            ((ObjectReceiver)this.getReceiver()).process((Object)new Triple(this.currentId, name, value, type));
        }
    }
}

