/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import java.util.Comparator;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.objects.Triple;
import org.metafacture.triples.AbstractTripleSort;

@Description(value="Counts triples")
@In(value=Triple.class)
@Out(value=Triple.class)
@FluxCommand(value="count-triples")
public final class TripleCount
extends AbstractTripleSort {
    public static final String DEFAULT_COUNT_PREDICATE = "count";
    @Deprecated
    public static final String DEFAULT_COUNTP_REDICATE = "count";
    private static final Triple INIT = new Triple("", "", "");
    private Triple current = INIT;
    private int count;
    private String countPredicate = "count";
    private Comparator<Triple> comparator;

    @Override
    protected void sortedTriple(Triple triple) {
        if (this.current == INIT) {
            this.current = triple;
            this.comparator = this.createComparator();
        }
        if (this.comparator.compare(this.current, triple) == 0) {
            ++this.count;
        } else {
            this.writeResult();
            this.current = triple;
            this.count = 1;
        }
    }

    public void setCountPredicate(String countPredicate) {
        this.countPredicate = countPredicate;
    }

    @Override
    protected void onFinished() {
        this.writeResult();
    }

    private void writeResult() {
        AbstractTripleSort.Compare compareBy = this.getCompare();
        switch (compareBy) {
            case ALL: {
                ((ObjectReceiver)this.getReceiver()).process((Object)new Triple(this.current.toString(), this.countPredicate, String.valueOf(this.count)));
                break;
            }
            case OBJECT: {
                ((ObjectReceiver)this.getReceiver()).process((Object)new Triple(this.current.getObject(), this.countPredicate, String.valueOf(this.count)));
                break;
            }
            case PREDICATE: {
                ((ObjectReceiver)this.getReceiver()).process((Object)new Triple(this.current.getPredicate(), this.countPredicate, String.valueOf(this.count)));
                break;
            }
            default: {
                ((ObjectReceiver)this.getReceiver()).process((Object)new Triple(this.current.getSubject(), this.countPredicate, String.valueOf(this.count)));
            }
        }
    }

    public void setCountBy(AbstractTripleSort.Compare countBy) {
        this.setCompare(countBy);
    }
}

