/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.ObjectReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.framework.objects.Triple;

@Description(value="Filters triple. The  patterns for subject, predicate and object are disjunctive.")
@In(value=Triple.class)
@Out(value=Triple.class)
@FluxCommand(value="filter-triples")
public final class TripleFilter
extends DefaultObjectPipe<Triple, ObjectReceiver<Triple>> {
    private static final Matcher MATCH_NOTHING = Pattern.compile("$a").matcher("");
    private Matcher subjectMatcher = MATCH_NOTHING;
    private Matcher predicateMatcher = MATCH_NOTHING;
    private Matcher objectMatcher = MATCH_NOTHING;
    private boolean passMatches = true;

    public String getSubjectPattern() {
        return this.subjectMatcher.pattern().pattern();
    }

    public void setSubjectPattern(String pattern) {
        this.subjectMatcher = Pattern.compile(pattern).matcher("");
    }

    public String getPredicatePattern() {
        return this.predicateMatcher.pattern().pattern();
    }

    public void setPredicatePattern(String pattern) {
        this.predicateMatcher = Pattern.compile(pattern).matcher("");
    }

    public String getObjectPattern() {
        return this.objectMatcher.pattern().pattern();
    }

    public void setObjectPattern(String pattern) {
        this.objectMatcher = Pattern.compile(pattern).matcher("");
    }

    public boolean isPassMatches() {
        return this.passMatches;
    }

    public void setPassMatches(boolean passMatches) {
        this.passMatches = passMatches;
    }

    public void process(Triple obj) {
        boolean matches;
        this.subjectMatcher.reset(obj.getSubject());
        this.predicateMatcher.reset(obj.getPredicate());
        this.objectMatcher.reset(obj.getObject());
        boolean bl = matches = this.subjectMatcher.matches() || this.predicateMatcher.matches() || this.objectMatcher.matches();
        if (matches && this.passMatches || !matches && !this.passMatches) {
            ((ObjectReceiver)this.getReceiver()).process((Object)obj);
        }
    }
}

