/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectReceiver;
import org.metafacture.framework.objects.Triple;

@Description(value="Writes the object value of the triple into a file. The filename is constructed from subject and predicate. Please note: This module does not check if the filename constructed from subject and predicate stays within `baseDir`. THIS MODULE SHOULD NOT BE USED IN ENVIRONMENTS IN WHICH THE VALUES OF SUBJECT AND PREDICATE A PROVIDED BY AN UNTRUSTED SOURCE!")
@In(value=Triple.class)
@Out(value=Void.class)
@FluxCommand(value="write-triple-objects")
public final class TripleObjectWriter
extends DefaultObjectReceiver<Triple> {
    private final Path baseDir;
    private Charset encoding = StandardCharsets.UTF_8;

    public TripleObjectWriter(String baseDir) {
        this.baseDir = Paths.get(baseDir, new String[0]);
    }

    public void setEncoding(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding.name();
    }

    public void process(Triple triple) {
        Path filePath = this.buildFilePath(triple);
        this.ensureParentPathExists(filePath);
        try (BufferedWriter writer = Files.newBufferedWriter(filePath, this.encoding, new OpenOption[0]);){
            writer.write(triple.getObject());
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    private Path buildFilePath(Triple triple) {
        Path file = Paths.get(triple.getSubject(), triple.getPredicate());
        return this.baseDir.resolve(file).toAbsolutePath().normalize();
    }

    private void ensureParentPathExists(Path path) {
        Path parentDir = path.getParent();
        if (parentDir != null) {
            try {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MetafactureException((Throwable)e);
            }
        }
    }
}

