/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.MetafactureException;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectReceiver;
import org.metafacture.framework.objects.Triple;

@Description(value="Writes triples into a file.")
@In(value=Triple.class)
@Out(value=Void.class)
@FluxCommand(value="write-triples")
public final class TripleWriter
extends DefaultObjectReceiver<Triple> {
    public static final int BUFFERSIZE = 2048;
    private final String filename;
    private ObjectOutputStream outputStream;

    public TripleWriter(String filename) {
        this.filename = filename;
        this.resetStream();
    }

    public void process(Triple obj) {
        try {
            obj.write(this.outputStream);
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    public void resetStream() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            this.outputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.filename), 2048));
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }

    public void closeStream() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            throw new MetafactureException((Throwable)e);
        }
    }
}

