/*
 * Decompiled with CFR 0.152.
 */
package org.metafacture.triples;

import org.metafacture.formeta.parser.Emitter;
import org.metafacture.formeta.parser.FormetaParser;
import org.metafacture.formeta.parser.PartialRecordEmitter;
import org.metafacture.framework.FluxCommand;
import org.metafacture.framework.StreamReceiver;
import org.metafacture.framework.annotations.Description;
import org.metafacture.framework.annotations.In;
import org.metafacture.framework.annotations.Out;
import org.metafacture.framework.helpers.DefaultObjectPipe;
import org.metafacture.framework.objects.Triple;

@Description(value="Converts a triple into a record stream")
@In(value=Triple.class)
@Out(value=StreamReceiver.class)
@FluxCommand(value="triples-to-stream")
public final class TriplesToStream
extends DefaultObjectPipe<Triple, StreamReceiver> {
    private final FormetaParser parser = new FormetaParser();
    private final PartialRecordEmitter emitter = new PartialRecordEmitter();

    public TriplesToStream() {
        this.parser.setEmitter((Emitter)this.emitter);
    }

    public void process(Triple triple) {
        ((StreamReceiver)this.getReceiver()).startRecord(triple.getSubject());
        if (triple.getObjectType() == Triple.ObjectType.STRING) {
            ((StreamReceiver)this.getReceiver()).literal(triple.getPredicate(), triple.getObject());
        } else if (triple.getObjectType() == Triple.ObjectType.ENTITY) {
            this.emitter.setDefaultName(triple.getPredicate());
            this.parser.parse(triple.getObject());
        } else {
            throw new UnsupportedOperationException(triple.getObjectType() + " can not yet be decoded");
        }
        ((StreamReceiver)this.getReceiver()).endRecord();
    }

    protected void onSetReceiver() {
        this.emitter.setReceiver((StreamReceiver)this.getReceiver());
    }
}

