/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.data.TableData;
import org.meteoinfo.data.TimeTableData;
import org.meteoinfo.data.analysis.Statistics;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.table.DataTable;
import org.mozilla.universalchardet.UniversalDetector;

public class TableUtil {
    public static TableData readASCIIFile(String fileName, String delimiter, int headerLines, String formatSpec, String encoding, boolean readVarNames) throws FileNotFoundException, IOException, Exception {
        if (encoding == null) {
            encoding = UniversalDetector.detectCharset((File)new File(fileName));
        }
        TableData tableData = new TableData();
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
        if (headerLines > 0) {
            for (int i = 0; i < headerLines; ++i) {
                sr.readLine();
            }
        }
        String title = sr.readLine().trim();
        switch (encoding) {
            case "UTF8": 
            case "UTF-8": 
            case "UTF-16BE": 
            case "UTF-16LE": 
            case "UTF-32BE": 
            case "UTF-32LE": {
                if (!title.startsWith("\ufeff")) break;
                title = title.substring(1);
            }
        }
        String[] titleArray = GlobalUtil.split((String)title, (String)delimiter);
        int colNum = titleArray.length;
        if (headerLines == -1 || !readVarNames) {
            for (int i = 0; i < colNum; ++i) {
                titleArray[i] = "Col_" + String.valueOf(i);
            }
        }
        boolean hasTimeCol = false;
        String tcolName = null;
        if (titleArray.length < 2) {
            System.out.println("File Format Error!");
            sr.close();
        } else {
            String[] colFormats;
            if (formatSpec == null) {
                colFormats = new String[colNum];
                for (int i = 0; i < colNum; ++i) {
                    colFormats[i] = "C";
                }
            } else {
                colFormats = formatSpec.split("%");
            }
            int idx = 0;
            boolean isBreak = false;
            for (String colFormat : colFormats) {
                if (colFormat.isEmpty()) continue;
                int num = 1;
                if (colFormat.length() > 1 && !colFormat.substring(0, 1).equals("{")) {
                    int index = colFormat.indexOf("{");
                    if (index < 0) {
                        index = colFormat.length() - 1;
                    }
                    num = Integer.parseInt(colFormat.substring(0, index));
                    colFormat = colFormat.substring(index);
                }
                for (int i = 0; i < num; ++i) {
                    String colName = titleArray[idx].trim();
                    if (colFormat.equals("C") || colFormat.equals("s")) {
                        tableData.addColumn(colName, DataType.STRING);
                    } else if (colFormat.equals("i")) {
                        tableData.addColumn(colName, DataType.INT);
                    } else if (colFormat.equals("f")) {
                        tableData.addColumn(colName, DataType.FLOAT);
                    } else if (colFormat.equals("d")) {
                        tableData.addColumn(colName, DataType.DOUBLE);
                    } else if (colFormat.equals("B")) {
                        tableData.addColumn(colName, DataType.BOOLEAN);
                    } else if (colFormat.substring(0, 1).equals("{")) {
                        int eidx = colFormat.indexOf("}");
                        String formatStr = colFormat.substring(1, eidx);
                        tableData.addColumn(new DataColumn(colName, DataType.DATE, formatStr));
                        hasTimeCol = true;
                        if (tcolName == null) {
                            tcolName = titleArray[idx];
                        }
                    } else {
                        tableData.addColumn(colName, DataType.STRING);
                    }
                    if (++idx != colNum) continue;
                    isBreak = true;
                    break;
                }
                if (isBreak) break;
            }
            if (idx < colNum) {
                for (int i = idx; i < colNum; ++i) {
                    tableData.addColumn(titleArray[i], DataType.STRING);
                }
            }
            int rn = 0;
            String line = headerLines == -1 || !readVarNames ? title : sr.readLine();
            while (line != null) {
                int i;
                if ((line = line.trim()).isEmpty()) {
                    line = sr.readLine();
                    continue;
                }
                String[] dataArray = GlobalUtil.split((String)line, (String)delimiter);
                tableData.addRow();
                int cn = 0;
                for (i = 0; i < dataArray.length && cn < colNum; ++cn, ++i) {
                    tableData.setValue(rn, cn, dataArray[i]);
                }
                if (cn < colNum) {
                    for (i = cn; i < colNum; ++i) {
                        tableData.setValue(rn, i, "");
                    }
                }
                ++rn;
                line = sr.readLine();
            }
            sr.close();
        }
        if (hasTimeCol) {
            TimeTableData tTableData = new TimeTableData(tableData, tcolName);
            return tTableData;
        }
        return tableData;
    }

    public static TableData readASCIIFile(String fileName, String delimiter, int headerLines, String formatSpec, String encoding, boolean readVarNames, List<Object> usecolsin) throws FileNotFoundException, IOException, Exception {
        if (encoding == null) {
            encoding = UniversalDetector.detectCharset((File)new File(fileName));
        }
        TableData tableData = new TableData();
        BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), encoding));
        if (headerLines > 0) {
            for (int i = 0; i < headerLines; ++i) {
                sr.readLine();
            }
        }
        String title = sr.readLine().trim();
        switch (encoding) {
            case "UTF8": 
            case "UTF-8": 
            case "UTF-16BE": 
            case "UTF-16LE": 
            case "UTF-32BE": 
            case "UTF-32LE": {
                if (!title.startsWith("\ufeff")) break;
                title = title.substring(1);
            }
        }
        String[] titleArray1 = GlobalUtil.split((String)title, (String)delimiter);
        ArrayList<Integer> usecols = new ArrayList<Integer>();
        if (usecolsin.get(0) instanceof Integer) {
            for (Object o : usecolsin) {
                usecols.add((Integer)o);
            }
        } else {
            ArrayList<String> titleArray2 = new ArrayList<String>(Arrays.asList(titleArray1));
            for (Object o : usecolsin) {
                int idx = titleArray2.indexOf((String)o);
                if (idx < 0) continue;
                usecols.add(idx);
            }
        }
        ArrayList<String> titleArray = new ArrayList<String>();
        for (int i = 0; i < titleArray1.length; ++i) {
            if (!usecols.contains(i)) continue;
            titleArray.add(titleArray1[i]);
        }
        int colNum = titleArray.size();
        if (headerLines == -1 || !readVarNames) {
            for (int i = 0; i < colNum; ++i) {
                titleArray.set(i, "Col_" + String.valueOf(i));
            }
        }
        boolean hasTimeCol = false;
        String tcolName = null;
        if (titleArray.size() < 2) {
            System.out.println("File Format Error!");
            sr.close();
        } else {
            String[] colFormats;
            if (formatSpec == null) {
                colFormats = new String[colNum];
                for (int i = 0; i < colNum; ++i) {
                    colFormats[i] = "C";
                }
            } else {
                colFormats = formatSpec.split("%");
            }
            int idx = 0;
            boolean isBreak = false;
            for (String colFormat : colFormats) {
                if (colFormat.isEmpty()) continue;
                int num = 1;
                if (colFormat.length() > 1 && !colFormat.substring(0, 1).equals("{")) {
                    int index = colFormat.indexOf("{");
                    if (index < 0) {
                        index = colFormat.length() - 1;
                    }
                    num = Integer.parseInt(colFormat.substring(0, index));
                    colFormat = colFormat.substring(index);
                }
                for (int i = 0; i < num; ++i) {
                    String colName = ((String)titleArray.get(idx)).trim();
                    if (colFormat.equals("C") || colFormat.equals("s")) {
                        tableData.addColumn(colName, DataType.STRING);
                    } else if (colFormat.equals("i")) {
                        tableData.addColumn(colName, DataType.INT);
                    } else if (colFormat.equals("f")) {
                        tableData.addColumn(colName, DataType.FLOAT);
                    } else if (colFormat.equals("d")) {
                        tableData.addColumn(colName, DataType.DOUBLE);
                    } else if (colFormat.equals("B")) {
                        tableData.addColumn(colName, DataType.BOOLEAN);
                    } else if (colFormat.substring(0, 1).equals("{")) {
                        int eidx = colFormat.indexOf("}");
                        String formatStr = colFormat.substring(1, eidx);
                        tableData.addColumn(new DataColumn(colName, DataType.DATE, formatStr));
                        hasTimeCol = true;
                        if (tcolName == null) {
                            tcolName = (String)titleArray.get(idx);
                        }
                    } else {
                        tableData.addColumn(colName, DataType.STRING);
                    }
                    if (++idx != colNum) continue;
                    isBreak = true;
                    break;
                }
                if (isBreak) break;
            }
            if (idx < colNum) {
                for (int i = idx; i < colNum; ++i) {
                    tableData.addColumn((String)titleArray.get(i), DataType.STRING);
                }
            }
            int rn = 0;
            String line = headerLines == -1 || !readVarNames ? title : sr.readLine();
            while (line != null) {
                int i;
                if ((line = line.trim()).isEmpty()) {
                    line = sr.readLine();
                    continue;
                }
                String[] dataArray = GlobalUtil.split((String)line, (String)delimiter);
                tableData.addRow();
                int cn = 0;
                for (i = 0; i < dataArray.length && cn < colNum; ++i) {
                    if (!usecols.contains(i)) continue;
                    tableData.setValue(rn, cn, dataArray[i]);
                    ++cn;
                }
                if (cn < colNum) {
                    for (i = cn; i < colNum; ++i) {
                        tableData.setValue(rn, i, "");
                    }
                }
                ++rn;
                line = sr.readLine();
            }
            sr.close();
        }
        if (hasTimeCol) {
            TimeTableData tTableData = new TimeTableData(tableData, tcolName);
            return tTableData;
        }
        return tableData;
    }

    public static List<String> getFormats(String formatSpec) {
        String[] colFormats;
        if (formatSpec == null) {
            return null;
        }
        ArrayList<String> formats = new ArrayList<String>();
        for (String colFormat : colFormats = formatSpec.split("%")) {
            if (colFormat.isEmpty()) continue;
            if (colFormat.substring(0, 1).equals("{")) {
                int eidx = colFormat.indexOf("}");
                colFormat = colFormat.substring(1, eidx);
            } else {
                colFormat = "%" + colFormat;
            }
            formats.add(colFormat);
        }
        return formats;
    }

    public static DataType toDataTypes(String dt) {
        if (dt.contains("%")) {
            dt = dt.split("%")[1];
        }
        switch (dt.toLowerCase()) {
            case "c": 
            case "s": 
            case "string": {
                return DataType.STRING;
            }
            case "i": 
            case "int": {
                return DataType.INT;
            }
            case "f": 
            case "float": {
                return DataType.FLOAT;
            }
            case "d": 
            case "double": {
                return DataType.DOUBLE;
            }
        }
        if (dt.substring(0, 1).equals("{")) {
            return DataType.DATE;
        }
        return DataType.STRING;
    }

    public static String getDateFormat(String dt) {
        int sidx = dt.indexOf("{");
        int eidx = dt.indexOf("}");
        String formatStr = dt.substring(sidx + 1, eidx);
        return formatStr;
    }

    public static DataTable ave_Month(List<Array> data, List<String> colNames, List<LocalDateTime> time) throws Exception {
        DataTable rTable = new DataTable();
        rTable.addColumn("YearMonth", DataType.STRING);
        for (String col : colNames) {
            rTable.addColumn(col, DataType.DOUBLE);
        }
        List<String> yms = TableUtil.getYearMonths(time);
        for (String ym : yms) {
            int year = Integer.parseInt(ym.substring(0, 4));
            int month = Integer.parseInt(ym.substring(4));
            DataRow nRow = rTable.addRow();
            nRow.setValue(0, (Object)ym);
            int col = 0;
            for (Array a : data) {
                ArrayList<Double> values = new ArrayList<Double>();
                for (int i = 0; i < time.size(); ++i) {
                    double v;
                    LocalDateTime ldt = time.get(i);
                    if (ldt.getYear() != year || ldt.getMonthValue() != month || Double.isNaN(v = a.getDouble(i))) continue;
                    values.add(v);
                }
                nRow.setValue(colNames.get(col), (Object)Statistics.mean(values));
                ++col;
            }
        }
        return rTable;
    }

    public static List<String> getYearMonths(List<LocalDateTime> time) {
        ArrayList<String> yms = new ArrayList<String>();
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMM");
        for (LocalDateTime t : time) {
            String ym = format.format(t);
            if (yms.contains(ym)) continue;
            yms.add(ym);
        }
        return yms;
    }
}

