/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.data.XYSeriesData;
import org.meteoinfo.ndarray.Array;

public class XYYSeriesData
extends XYSeriesData {
    private double[] y2data;
    private List<Boolean> where;

    public XYYSeriesData() {
    }

    public XYYSeriesData(String key, double[] xdata, double[] ydata, double[] y2data) {
        super(key, xdata, ydata);
        this.y2data = y2data;
    }

    public double[] getY2data() {
        return this.y2data;
    }

    public void setY2data(double[] value) {
        this.y2data = value;
    }

    public void setY2data(List<Number> value) {
        this.y2data = new double[value.size()];
        for (int i = 0; i < value.size(); ++i) {
            double v = value.get(i).doubleValue();
            this.y2data[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public void setY2data(Array value) {
        this.y2data = new double[(int)value.getSize()];
        for (int i = 0; i < this.y2data.length; ++i) {
            double v = value.getDouble(i);
            this.y2data[i] = Double.isNaN(v) ? this.getMissingValue() : v;
        }
    }

    public List<Boolean> getWhere() {
        return this.where;
    }

    public void setWhere(List<Boolean> value) {
        this.where = value;
    }

    public void setWhere(Array value) {
        this.where = new ArrayList<Boolean>();
        int i = 0;
        while ((long)i < value.getSize()) {
            this.where.add(value.getInt(i) == 1);
            ++i;
        }
    }
}

