/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata;

import java.nio.ByteBuffer;
import java.util.Formatter;
import java.util.List;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.ArrayChar;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;

public class Attribute {
    private String name;
    private DataType dataType;
    private String svalue;
    private int nelems;
    private Array values;
    private boolean isUnsigned;

    public Attribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Trying to set name to null on " + this);
        }
        this.name = name;
    }

    public Attribute(String name, Array values) {
        this(name);
        this.setValues(values);
    }

    public Attribute(String name, List values) {
        this(name);
        Object[] pa;
        int n = values.size();
        Class<?> c = values.get(0).getClass();
        if (c == String.class) {
            String[] va;
            pa = va = new String[n];
            for (int i = 0; i < n; ++i) {
                va[i] = (String)values.get(i);
            }
        } else if (c == Integer.class) {
            int[] va = new int[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Integer)values.get(i);
            }
        } else if (c == Double.class) {
            double[] va = new double[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Double)values.get(i);
            }
        } else if (c == Float.class) {
            float[] va = new float[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = ((Float)values.get(i)).floatValue();
            }
        } else if (c == Short.class) {
            short[] va = new short[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Short)values.get(i);
            }
        } else if (c == Byte.class) {
            byte[] va = new byte[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Byte)values.get(i);
            }
        } else if (c == Long.class) {
            long[] va = new long[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Long)values.get(i);
            }
        } else {
            throw new IllegalArgumentException("unknown type for Attribute = " + c.getName());
        }
        this.setValues(Array.factory(c, (int[])new int[]{n}, (Object)pa));
    }

    public Attribute(String name, Number val) {
        this(name, val, false);
    }

    public Attribute(String name, Number val, boolean isUnsigned) {
        this(name);
        int[] shape = new int[]{1};
        DataType dt = DataType.getType(val.getClass());
        Array vala = Array.factory((DataType)dt, (int[])shape);
        Index ima = vala.getIndex();
        vala.setObject(ima.set0(0), (Object)val);
        this.setValues(vala);
        this.isUnsigned = isUnsigned;
    }

    public Attribute(String name, String val) {
        this(name);
        this.setStringValue(val);
    }

    public String getShortName() {
        return this.name;
    }

    public void setShortName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public int getLength() {
        return this.nelems;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getStringValue() {
        return this.svalue;
    }

    public String getStringValue(int index) {
        if (this.dataType != DataType.STRING) {
            return null;
        }
        if (this.svalue != null && index == 0) {
            return this.svalue;
        }
        return this._getStringValue(index);
    }

    private String _getStringValue(int index) {
        if (index < 0 || index >= this.nelems) {
            return null;
        }
        return (String)this.values.getObject(index);
    }

    public void setStringValue(String val) {
        int len;
        if (val == null) {
            return;
        }
        for (len = val.length(); len > 0 && val.charAt(len - 1) == '\u0000'; --len) {
        }
        if (len != val.length()) {
            val = val.substring(0, len);
        }
        this.svalue = val;
        this.nelems = 1;
        this.dataType = DataType.STRING;
    }

    public Array getValues() {
        if (this.values == null && this.svalue != null) {
            this.values = Array.factory((DataType)DataType.STRING, (int[])new int[]{1});
            this.values.setObject(this.values.getIndex(), (Object)this.svalue);
        }
        return this.values;
    }

    public Object getValue(int index) {
        if (this.isString()) {
            return this.getStringValue(index);
        }
        return this.getNumericValue(index);
    }

    public Object getValue() {
        if (this.isString()) {
            return this.svalue;
        }
        return this.values;
    }

    public boolean isString() {
        return this.dataType == DataType.STRING && null != this.getStringValue();
    }

    public boolean isUnsigned() {
        return this.isUnsigned || this.values != null && this.values.isUnsigned();
    }

    public Number getNumericValue() {
        return this.getNumericValue(0);
    }

    public Number getNumericValue(int index) {
        if (index < 0 || index >= this.nelems) {
            return null;
        }
        if (this.dataType == DataType.STRING) {
            try {
                return Double.parseDouble(this.getStringValue(index));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (this.dataType == DataType.BYTE) {
            return this.values.getByte(index);
        }
        if (this.dataType == DataType.SHORT) {
            return this.values.getShort(index);
        }
        if (this.dataType == DataType.INT) {
            return this.values.getInt(index);
        }
        if (this.dataType == DataType.FLOAT) {
            return Float.valueOf(this.values.getFloat(index));
        }
        if (this.dataType == DataType.DOUBLE) {
            return this.values.getDouble(index);
        }
        if (this.dataType == DataType.LONG) {
            return this.values.getLong(index);
        }
        return null;
    }

    public void setValues(Array arr) {
        if (arr == null) {
            this.dataType = DataType.STRING;
            return;
        }
        if (DataType.getType((Class)arr.getElementType()) == null) {
            throw new IllegalArgumentException("Cant set Attribute with type " + arr.getElementType());
        }
        if (arr.getElementType() == Character.TYPE) {
            ArrayChar carr = (ArrayChar)arr;
            if (carr.getRank() == 1) {
                this.svalue = carr.getString();
                this.nelems = 1;
                this.dataType = DataType.STRING;
                return;
            }
            arr = carr.make1DStringArray();
        }
        if (arr.getElementType() == ByteBuffer.class) {
            int totalLen = 0;
            arr.resetLocalIterator();
            while (arr.hasNext()) {
                ByteBuffer bb = (ByteBuffer)arr.next();
                totalLen += bb.limit();
            }
            byte[] ba = new byte[totalLen];
            int pos = 0;
            arr.resetLocalIterator();
            while (arr.hasNext()) {
                ByteBuffer bb = (ByteBuffer)arr.next();
                System.arraycopy(bb.array(), 0, ba, pos, bb.limit());
                pos += bb.limit();
            }
            arr = Array.factory((DataType)DataType.BYTE, (int[])new int[]{totalLen}, (Object)ba);
        }
        if (arr.getRank() > 1) {
            arr = arr.reshape(new int[]{(int)arr.getSize()});
        }
        this.values = arr;
        this.nelems = (int)arr.getSize();
        this.dataType = DataType.getType((Class)arr.getElementType());
    }

    protected void writeCDL(Formatter f) {
        f.format("%s", this.getShortName());
        if (this.isString()) {
            f.format(" = ", new Object[0]);
            for (int i = 0; i < this.getLength(); ++i) {
                String val;
                if (i != 0) {
                    f.format(", ", new Object[0]);
                }
                if ((val = this.getStringValue(i)) == null) continue;
                f.format("\"%s\"", val);
            }
        } else {
            f.format(" = ", new Object[0]);
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    f.format(", ", new Object[0]);
                }
                f.format("%s", this.getNumericValue(i));
                if (this.dataType == DataType.FLOAT) {
                    f.format("f", new Object[0]);
                    continue;
                }
                if (this.dataType == DataType.SHORT) {
                    if (this.isUnsigned()) {
                        f.format("US", new Object[0]);
                        continue;
                    }
                    f.format("S", new Object[0]);
                    continue;
                }
                if (this.dataType == DataType.BYTE) {
                    if (this.isUnsigned()) {
                        f.format("UB", new Object[0]);
                        continue;
                    }
                    f.format("B", new Object[0]);
                    continue;
                }
                if (this.dataType == DataType.LONG) {
                    if (this.isUnsigned()) {
                        f.format("UL", new Object[0]);
                        continue;
                    }
                    f.format("L", new Object[0]);
                    continue;
                }
                if (this.dataType != DataType.INT || !this.isUnsigned()) continue;
                f.format("U", new Object[0]);
            }
        }
    }

    public String toString() {
        Formatter f = new Formatter();
        this.writeCDL(f);
        return f.toString();
    }
}

