/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.ascii;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;

public class SurferGridDataInfo
extends DataInfo
implements IGridDataInfo {
    public SurferGridDataInfo() {
        this.setDataType(MeteoDataType.SURFER_GRID);
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    @Override
    public void readDataInfo(String fileName) {
        try {
            int i;
            this.setFileName(fileName);
            BufferedReader sr = new BufferedReader(new FileReader(new File(fileName)));
            String aLine = sr.readLine().trim();
            for (i = 1; i <= 4; ++i) {
                aLine = aLine + " " + sr.readLine().trim();
            }
            String[] dataArray = aLine.split("\\s+");
            int xnum = Integer.parseInt(dataArray[1]);
            int ynum = Integer.parseInt(dataArray[2]);
            double xmin = Double.parseDouble(dataArray[3]);
            double xmax = Double.parseDouble(dataArray[4]);
            double ymin = Double.parseDouble(dataArray[5]);
            double ymax = Double.parseDouble(dataArray[6]);
            double zmin = Double.parseDouble(dataArray[7]);
            double zmax = Double.parseDouble(dataArray[8]);
            double xdelt = (xmax - xmin) / (double)(xnum - 1);
            double ydelt = (ymax - ymin) / (double)(ynum - 1);
            double[] X = new double[xnum];
            for (i = 0; i < xnum; ++i) {
                X[i] = xmin + (double)i * xdelt;
            }
            if (X[xnum - 1] + xdelt - X[0] == 360.0) {
                this.setGlobal(true);
            }
            double[] Y = new double[ynum];
            for (i = 0; i < ynum; ++i) {
                Y[i] = ymin + (double)i * ydelt;
            }
            Dimension xDim = new Dimension(DimensionType.X);
            xDim.setValues(X);
            this.setXDimension(xDim);
            Dimension yDim = new Dimension(DimensionType.Y);
            yDim.setValues(Y);
            this.setYDimension(yDim);
            ArrayList<Variable> variables = new ArrayList<Variable>();
            Variable aVar = new Variable();
            aVar.setName("var");
            aVar.addDimension(yDim);
            aVar.addDimension(xDim);
            variables.add(aVar);
            this.setVariables(variables);
            sr.close();
        }
        catch (IOException ex) {
            Logger.getLogger(SurferGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "File Name: " + this.getFileName();
        dataInfo = dataInfo + System.getProperty("line.separator") + "Data Type: Sufer ASCII Grid";
        Dimension xdim = this.getXDimension();
        Dimension ydim = this.getYDimension();
        dataInfo = dataInfo + System.getProperty("line.separator") + "XNum = " + String.valueOf(xdim.getLength()) + "  YNum = " + String.valueOf(ydim.getLength());
        dataInfo = dataInfo + System.getProperty("line.separator") + "XMin = " + String.valueOf(xdim.getValues()[0]) + "  YMin = " + String.valueOf(ydim.getValues()[0]);
        dataInfo = dataInfo + System.getProperty("line.separator") + "XSize = " + String.valueOf(xdim.getValues()[1] - xdim.getValues()[0]) + "  YSize = " + String.valueOf(ydim.getValues()[1] - ydim.getValues()[0]);
        dataInfo = dataInfo + System.getProperty("line.separator") + "UNDEF = " + String.valueOf(this.getMissingValue());
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        try {
            Section section = new Section(origin, size, stride);
            Array dataArray = Array.factory((DataType)DataType.FLOAT, (int[])section.getShape());
            int rangeIdx = 0;
            Range yRange = section.getRange(rangeIdx++);
            Range xRange = section.getRange(rangeIdx);
            IndexIterator ii = dataArray.getIndexIterator();
            this.readXY(yRange, xRange, ii);
            return dataArray;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(SurferGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private void readXY(Range yRange, Range xRange, IndexIterator ii) {
        try {
            int xNum = this.getXDimension().getLength();
            int yNum = this.getYDimension().getLength();
            float[] data = new float[yNum * xNum];
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            for (int i = 0; i < 5; ++i) {
                sr.readLine();
            }
            int idx = 0;
            String aLine = sr.readLine();
            while (aLine != null) {
                String[] dataArray;
                for (String dstr : dataArray = aLine.trim().split("\\s+")) {
                    data[idx] = Float.parseFloat(dstr);
                    ++idx;
                }
                aLine = sr.readLine();
            }
            sr.close();
            for (int y = yRange.first(); y <= yRange.last(); y += yRange.stride()) {
                for (int x = xRange.first(); x <= xRange.last(); x += xRange.stride()) {
                    int index = y * xNum + x;
                    ii.setFloatNext(data[index]);
                }
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(SurferGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(SurferGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public GridArray getGridArray(String varName) {
        return null;
    }

    @Override
    public GridData getGridData_LonLat(int timeIdx, String varName, int levelIdx) {
        try {
            int xNum = this.getXDimension().getLength();
            int yNum = this.getYDimension().getLength();
            double[][] theData = new double[yNum][xNum];
            BufferedReader sr = new BufferedReader(new FileReader(new File(this.getFileName())));
            for (int i = 0; i < 5; ++i) {
                sr.readLine();
            }
            int d = 0;
            String aLine = sr.readLine();
            while (aLine != null) {
                String[] dataArray;
                if (aLine.isEmpty()) {
                    aLine = sr.readLine();
                    continue;
                }
                for (String dstr : dataArray = aLine.trim().split("\\s+")) {
                    int ii = d / xNum;
                    int jj = d % xNum;
                    if (ii >= yNum) {
                        ++d;
                        break;
                    }
                    if (jj >= xNum) {
                        ++d;
                        break;
                    }
                    theData[ii][jj] = Double.parseDouble(dstr);
                    ++d;
                }
                aLine = sr.readLine();
            }
            sr.close();
            return new GridData(theData, this.getXDimension().getValues(), this.getYDimension().getValues(), this.missingValue);
        }
        catch (IOException ex) {
            Logger.getLogger(SurferGridDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public GridData getGridData_TimeLat(int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_TimeLon(int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLat(int lonIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelLon(int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_LevelTime(int latIdx, String varName, int lonIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Time(int lonIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Level(int lonIdx, int latIdx, String varName, int timeIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lon(int timeIdx, int latIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GridData getGridData_Lat(int timeIdx, int lonIdx, String varName, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

