/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.dataframe.Column;
import org.meteoinfo.dataframe.ColumnIndex;
import org.meteoinfo.dataframe.DataFrame;
import org.meteoinfo.dataframe.Index;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.math.ArrayMath;

public class MICAPS120DataInfo
extends DataInfo
implements IStationDataInfo {
    private String _description;
    private List<String> _varList = new ArrayList<String>();
    private final List<String> _fieldList = new ArrayList<String>();
    private final List<List<String>> _dataList = new ArrayList<List<String>>();
    private int stNum;

    public MICAPS120DataInfo() {
        this.setMissingValue(9999.0);
        this.setDataType(MeteoDataType.MICAPS_120);
        String[] items = new String[]{"AQI", "Grade", "PM2.5", "PM10", "CO", "NO2", "O3", "O3_8h", "SO2"};
        this._varList = Arrays.asList(items);
        this._fieldList.addAll(Arrays.asList("Stid", "Longitude", "Latitude"));
        this._fieldList.addAll(this._varList);
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDataInfo(String fileName) {
        BufferedReader sr = null;
        try {
            String line;
            String aLine;
            this.setFileName(fileName);
            sr = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            this._description = aLine = sr.readLine().trim();
            String dateStr = this._description.split("\\s+")[2];
            dateStr = dateStr.substring(dateStr.length() - 10);
            DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyyMMddHH");
            LocalDateTime time = LocalDateTime.parse(dateStr, format);
            Dimension tdim = new Dimension(DimensionType.T);
            double[] values = new double[]{JDateUtil.toOADate((LocalDateTime)time)};
            tdim.setValues(values);
            this.setTimeDimension(tdim);
            this.stNum = 0;
            while ((line = sr.readLine()) != null) {
                String[] dataArray = (line = line.trim()).split("\\s+");
                if (dataArray.length < 12) continue;
                ArrayList<String> aList = new ArrayList<String>();
                aList.add(dataArray[0]);
                aList.add(dataArray[2]);
                aList.add(dataArray[1]);
                for (int i = 3; i < dataArray.length; ++i) {
                    aList.add(dataArray[i]);
                }
                this._dataList.add(aList);
                ++this.stNum;
            }
            Dimension stdim = new Dimension(DimensionType.OTHER);
            stdim.setShortName("station");
            values = new double[this.stNum];
            for (int i = 0; i < this.stNum; ++i) {
                values[i] = i;
            }
            stdim.setValues(values);
            this.addDimension(stdim);
            ArrayList<Variable> variables = new ArrayList<Variable>();
            for (String vName : this._fieldList) {
                Variable var = new Variable();
                var.setName(vName);
                switch (vName) {
                    case "Stid": {
                        var.setDataType(DataType.STRING);
                    }
                }
                var.setStation(true);
                var.setDimension(stdim);
                var.setFillValue(this.getMissingValue());
                variables.add(var);
            }
            this.setVariables(variables);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPS120DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(MICAPS120DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS120DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (sr != null) {
                    sr.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS120DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "Description: " + this._description;
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00");
        dataInfo = dataInfo + System.getProperty("line.separator") + "Time: " + format.format(this.getTimes().get(0));
        dataInfo = dataInfo + System.getProperty("line.separator") + super.generateInfoText();
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        int varIdx = this._fieldList.indexOf(varName);
        if (varIdx < 0) {
            return null;
        }
        DataType dt = DataType.FLOAT;
        switch (varName) {
            case "Stid": {
                dt = DataType.STRING;
                break;
            }
            case "Grade": {
                dt = DataType.INT;
            }
        }
        int[] shape = new int[]{this.stNum};
        Array r = Array.factory((DataType)dt, (int[])shape);
        block18: for (int i = 0; i < this._dataList.size(); ++i) {
            List<String> dataList = this._dataList.get(i);
            if (varIdx < dataList.size()) {
                switch (dt) {
                    case STRING: {
                        r.setObject(i, (Object)dataList.get(varIdx));
                        break;
                    }
                    case INT: {
                        int vi = Integer.parseInt(dataList.get(varIdx));
                        r.setInt(i, vi);
                        break;
                    }
                    case FLOAT: {
                        float v = Float.parseFloat(dataList.get(varIdx));
                        r.setFloat(i, v);
                    }
                }
                continue;
            }
            switch (dt) {
                case STRING: {
                    r.setObject(i, (Object)"Null");
                    continue block18;
                }
                case INT: {
                    r.setInt(i, Integer.MIN_VALUE);
                    continue block18;
                }
                case FLOAT: {
                    r.setFloat(i, Float.NaN);
                }
            }
        }
        return r;
    }

    public DataFrame readDataFrame() {
        ArrayList<Array> data = new ArrayList<Array>();
        ColumnIndex columns = new ColumnIndex();
        Iterator<String> iterator = this._fieldList.iterator();
        block13: while (iterator.hasNext()) {
            DataType dtype;
            String vName;
            switch (vName = iterator.next()) {
                case "Stid": {
                    continue block13;
                }
                case "AQI": 
                case "Grade": {
                    dtype = DataType.INT;
                    break;
                }
                default: {
                    dtype = DataType.FLOAT;
                }
            }
            columns.add((Object)new Column(vName, dtype));
            data.add(Array.factory((DataType)dtype, (int[])new int[]{this._dataList.size()}));
        }
        ArrayList<String> idxList = new ArrayList<String>();
        for (int i = 0; i < this._dataList.size(); ++i) {
            List<String> dataList = this._dataList.get(i);
            idxList.add(dataList.get(0));
            block15: for (int j = 0; j < data.size(); ++j) {
                Array dd = (Array)data.get(j);
                switch (dd.getDataType()) {
                    case INT: {
                        dd.setObject(i, (Object)Integer.parseInt(dataList.get(j + 1)));
                        continue block15;
                    }
                    case FLOAT: {
                        float v = Float.parseFloat(dataList.get(j + 1));
                        dd.setObject(i, (Object)Float.valueOf(v));
                    }
                }
            }
        }
        for (Array a : data) {
            ArrayMath.missingToNaN((Array)a, (Number)9999);
        }
        Index index = Index.factory(idxList);
        DataFrame df = new DataFrame(data, index, columns);
        return df;
    }

    @Override
    public StationData getStationData(int timeIdx, String varName, int levelIdx) {
        int i;
        int varIdx = this.getVariableIndex(varName);
        ArrayList<double[]> disData = new ArrayList<double[]>();
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        ArrayList<String> stations = new ArrayList<String>();
        for (i = 0; i < this._dataList.size(); ++i) {
            List<String> dataList = this._dataList.get(i);
            if (varIdx >= dataList.size()) continue;
            String aStid = dataList.get(0);
            float lon = Float.parseFloat(dataList.get(1));
            float lat = Float.parseFloat(dataList.get(2));
            float t = Float.parseFloat(dataList.get(varIdx));
            stations.add(aStid);
            disData.add(new double[]{lon, lat, t});
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
                continue;
            }
            if (minX > lon) {
                minX = lon;
            } else if (maxX < lon) {
                maxX = lon;
            }
            if (minY > lat) {
                minY = lat;
                continue;
            }
            if (!(maxY < lat)) continue;
            maxY = lat;
        }
        Extent dataExtent = new Extent();
        dataExtent.minX = minX;
        dataExtent.maxX = maxX;
        dataExtent.minY = minY;
        dataExtent.maxY = maxY;
        StationData stData = new StationData();
        double[][] discreteData = new double[disData.size()][3];
        for (i = 0; i < disData.size(); ++i) {
            discreteData[i][0] = ((double[])disData.get(i))[0];
            discreteData[i][1] = ((double[])disData.get(i))[1];
            discreteData[i][2] = ((double[])disData.get(i))[2];
        }
        stData.data = discreteData;
        stData.stations = stations;
        stData.dataExtent = dataExtent;
        stData.missingValue = this.getMissingValue();
        return stData;
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        StationInfoData stInfoData = new StationInfoData();
        stInfoData.setDataList(this._dataList);
        stInfoData.setFields(this._fieldList);
        stInfoData.setVariables(this._varList);
        ArrayList<String> stations = new ArrayList<String>();
        this.stNum = this._dataList.size();
        for (int i = 0; i < this.stNum; ++i) {
            stations.add(this._dataList.get(i).get(0));
        }
        stInfoData.setStations(stations);
        return stInfoData;
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

