/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.util.JDateUtil;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModel;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.micaps.MICAPS3DataInfo;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class MICAPS2DataInfo
extends DataInfo
implements IStationDataInfo {
    private String _description;
    private List<String> _varList = new ArrayList<String>();
    private List<String> _fieldList = new ArrayList<String>();
    private List<List<String>> _dataList = new ArrayList<List<String>>();
    private int stNum;

    public MICAPS2DataInfo() {
        String[] items = new String[]{"Height", "Temperature", "DepDewPoint", "WindDirection", "WindSpeed"};
        this._varList = Arrays.asList(items);
        this._fieldList.addAll(Arrays.asList("Stid", "Longitude", "Latitude", "Altitude", "Grade"));
        this._fieldList.addAll(this._varList);
        this.setMissingValue(9999.0);
        this.setDataType(MeteoDataType.MICAPS_2);
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDataInfo(String fileName) {
        BufferedReader sr = null;
        try {
            int year;
            int i;
            String aLine;
            this.setFileName(fileName);
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "gbk"));
            ArrayList<String> dataList = new ArrayList<String>();
            this._description = aLine = sr.readLine().trim();
            aLine = sr.readLine().trim();
            String[] dataArray = aLine.split("\\s+");
            dataList.clear();
            for (i = 0; i < dataArray.length; ++i) {
                dataList.add(dataArray[i]);
            }
            if (dataList.size() < 6) {
                aLine = sr.readLine().trim();
                dataArray = aLine.split("\\s+");
                for (i = 0; i < dataArray.length; ++i) {
                    dataList.add(dataArray[i]);
                }
            }
            if ((year = Integer.parseInt((String)dataList.get(0))) < 100) {
                year = year < 50 ? 2000 + year : 1900 + year;
            }
            LocalDateTime time = LocalDateTime.of(year, Integer.parseInt((String)dataList.get(1)), Integer.parseInt((String)dataList.get(2)), Integer.parseInt((String)dataList.get(3)), 0, 0);
            int level = Integer.parseInt((String)dataList.get(4));
            this.stNum = Integer.parseInt((String)dataList.get(5));
            while ((aLine = sr.readLine()) != null) {
                aLine = aLine.trim();
                dataArray = aLine.split("\\s+");
                dataList = new ArrayList();
                for (i = 0; i < dataArray.length; ++i) {
                    dataList.add(dataArray[i]);
                }
                if (dataList.size() < 10) {
                    aLine = sr.readLine().trim();
                    dataArray = aLine.split("\\s+");
                    for (i = 0; i < dataArray.length; ++i) {
                        dataList.add(dataArray[i]);
                    }
                }
                this._dataList.add(dataList);
            }
            Dimension tdim = new Dimension(DimensionType.T);
            double[] values = new double[]{JDateUtil.toOADate((LocalDateTime)time)};
            tdim.setValues(values);
            this.setTimeDimension(tdim);
            Dimension zdim = new Dimension(DimensionType.Z);
            zdim.setValues(new double[]{level});
            this.setZDimension(zdim);
            Dimension stdim = new Dimension(DimensionType.OTHER);
            stdim.setShortName("station");
            values = new double[this.stNum];
            for (i = 0; i < this.stNum; ++i) {
                values[i] = i;
            }
            stdim.setValues(values);
            this.addDimension(stdim);
            ArrayList<Variable> variables = new ArrayList<Variable>();
            for (String vName : this._fieldList) {
                Variable var = new Variable();
                var.setName(vName);
                var.setStation(true);
                var.setDimension(stdim);
                var.setFillValue(this.getMissingValue());
                variables.add(var);
            }
            this.setVariables(variables);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPS3DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(MICAPS3DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS3DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                sr.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS3DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "Description: " + this._description;
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00");
        dataInfo = dataInfo + System.getProperty("line.separator") + "Time: " + format.format(this.getTimes().get(0));
        dataInfo = dataInfo + System.getProperty("line.separator") + super.generateInfoText();
        return dataInfo;
    }

    @Override
    public Array read(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.read(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        int varIdx = this._fieldList.indexOf(varName);
        if (varIdx < 0) {
            return null;
        }
        DataType dt = DataType.FLOAT;
        switch (varName) {
            case "Stid": {
                dt = DataType.STRING;
                break;
            }
            case "Grade": {
                dt = DataType.INT;
            }
        }
        int[] shape = new int[]{this.stNum};
        Array r = Array.factory((DataType)dt, (int[])shape);
        block13: for (int i = 0; i < this.stNum; ++i) {
            List<String> dataList = this._dataList.get(i);
            switch (dt) {
                case STRING: {
                    r.setObject(i, (Object)dataList.get(varIdx));
                    continue block13;
                }
                case INT: {
                    int vi = Integer.parseInt(dataList.get(varIdx));
                    r.setInt(i, vi);
                    continue block13;
                }
                case FLOAT: {
                    float v = Float.parseFloat(dataList.get(varIdx));
                    r.setFloat(i, v);
                }
            }
        }
        return r;
    }

    @Override
    public StationData getStationData(int timeIdx, String varName, int levelIdx) {
        int varIdx = this.getVariableIndex(varName);
        double t = 0.0;
        double[][] discreteData = new double[this._dataList.size()][3];
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        ArrayList<String> stations = new ArrayList<String>();
        for (int i = 0; i < this._dataList.size(); ++i) {
            List<String> dataList = this._dataList.get(i);
            String stName = dataList.get(0);
            double lon = Double.parseDouble(dataList.get(1));
            double lat = Double.parseDouble(dataList.get(2));
            t = Double.parseDouble(dataList.get(varIdx));
            stations.add(stName);
            discreteData[i][0] = lon;
            discreteData[i][1] = lat;
            discreteData[i][2] = t;
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
                continue;
            }
            if (minX > lon) {
                minX = lon;
            } else if (maxX < lon) {
                maxX = lon;
            }
            if (minY > lat) {
                minY = lat;
                continue;
            }
            if (!(maxY < lat)) continue;
            maxY = lat;
        }
        Extent dataExtent = new Extent();
        dataExtent.minX = minX;
        dataExtent.maxX = maxX;
        dataExtent.minY = minY;
        dataExtent.maxY = maxY;
        StationData stData = new StationData();
        stData.data = discreteData;
        stData.dataExtent = dataExtent;
        stData.missingValue = this.getMissingValue();
        stData.stations = stations;
        return stData;
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        StationInfoData stInfoData = new StationInfoData();
        stInfoData.setDataList(this._dataList);
        stInfoData.setFields(this._fieldList);
        stInfoData.setVariables(this._varList);
        return stInfoData;
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        StationModelData smData = new StationModelData();
        ArrayList<StationModel> smList = new ArrayList<StationModel>();
        float minX = 0.0f;
        float maxX = 0.0f;
        float minY = 0.0f;
        float maxY = 0.0f;
        for (int i = 0; i < this._dataList.size(); ++i) {
            List<String> dataList = this._dataList.get(i);
            String aStid = dataList.get(0);
            float lon = Float.parseFloat(dataList.get(1));
            float lat = Float.parseFloat(dataList.get(2));
            StationModel sm = new StationModel();
            sm.setStationIdentifer(aStid);
            sm.setLongitude(lon);
            sm.setLatitude(lat);
            sm.setWindDirection(Double.parseDouble(dataList.get(8)));
            sm.setWindSpeed(Double.parseDouble(dataList.get(9)));
            sm.setCloudCover(1.0);
            sm.setTemperature(Double.parseDouble(dataList.get(6)));
            double ddp = Double.parseDouble(dataList.get(7));
            sm.setDewPoint(sm.getTemperature() - ddp);
            sm.setPressure(Double.parseDouble(dataList.get(5)));
            smList.add(sm);
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
                continue;
            }
            if (minX > lon) {
                minX = lon;
            } else if (maxX < lon) {
                maxX = lon;
            }
            if (minY > lat) {
                minY = lat;
                continue;
            }
            if (!(maxY < lat)) continue;
            maxY = lat;
        }
        Extent dataExtent = new Extent();
        dataExtent.minX = minX;
        dataExtent.maxX = maxX;
        dataExtent.minY = minY;
        dataExtent.maxY = maxY;
        smData.setData(smList);
        smData.setDataExtent(dataExtent);
        smData.setMissingValue(this.getMissingValue());
        return smData;
    }
}

