/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import org.meteoinfo.common.DataConvert;

public class GenericHeader {
    public static int length = 32;
    public int magicNumber;
    public int majorVersion;
    public int minorVersion;
    public int genericType;
    public int productType;
    public byte[] reserved;

    public GenericHeader(RandomAccessFile raf) throws IOException {
        byte[] bytes = new byte[4];
        raf.read(bytes);
        this.magicNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[2];
        raf.read(bytes);
        this.majorVersion = DataConvert.bytes2UShort((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.minorVersion = DataConvert.bytes2UShort((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[4];
        raf.read(bytes);
        this.genericType = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.productType = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved = new byte[16];
        raf.read(this.reserved);
    }

    public GenericHeader(InputStream in) throws IOException {
        byte[] bytes = new byte[4];
        in.read(bytes);
        this.magicNumber = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[2];
        in.read(bytes);
        this.majorVersion = DataConvert.bytes2UShort((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        in.read(bytes);
        this.minorVersion = DataConvert.bytes2UShort((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[4];
        in.read(bytes);
        this.genericType = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        in.read(bytes);
        this.productType = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved = new byte[16];
        in.read(this.reserved);
    }
}

