/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.radar;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import org.meteoinfo.common.DataConvert;

public class SiteConfig {
    public static int length = 128;
    public String siteCode;
    public String siteName;
    public float latitude;
    public float longitude;
    public int antennaHeight;
    public int groundHeight;
    public float frequency;
    public float beamWidthHori;
    public float beamWidthVert;
    public int RADVersion;
    public short radarType;
    public short antennaGain;
    public short transmittingFeederLoss;
    public short receivingFeederLoss;
    public short otherLoss;
    public byte[] reserved;

    public SiteConfig(RandomAccessFile raf) throws IOException {
        byte[] bytes = new byte[8];
        raf.read(bytes);
        this.siteCode = new String(bytes).trim();
        bytes = new byte[32];
        raf.read(bytes);
        this.siteName = new String(bytes).trim();
        bytes = new byte[4];
        raf.read(bytes);
        this.latitude = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.longitude = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.antennaHeight = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.groundHeight = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.frequency = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.beamWidthHori = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.beamWidthVert = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.RADVersion = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[2];
        raf.read(bytes);
        this.radarType = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.antennaGain = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.transmittingFeederLoss = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.receivingFeederLoss = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.otherLoss = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved = new byte[46];
        raf.read(this.reserved);
    }

    public SiteConfig(InputStream raf) throws IOException {
        byte[] bytes = new byte[8];
        raf.read(bytes);
        this.siteCode = new String(bytes).trim();
        bytes = new byte[32];
        raf.read(bytes);
        this.siteName = new String(bytes).trim();
        bytes = new byte[4];
        raf.read(bytes);
        this.latitude = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.longitude = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.antennaHeight = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.groundHeight = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.frequency = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.beamWidthHori = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.beamWidthVert = DataConvert.bytes2Float((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.RADVersion = DataConvert.bytes2Int((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        bytes = new byte[2];
        raf.read(bytes);
        this.radarType = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.antennaGain = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.transmittingFeederLoss = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.receivingFeederLoss = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        raf.read(bytes);
        this.otherLoss = DataConvert.bytes2Short((byte[])bytes, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.reserved = new byte[46];
        raf.read(this.reserved);
    }
}

