/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.MAMath;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;

public class DimArray {
    private Array array;
    private List<Dimension> dimensions;

    public DimArray() {
        this.array = null;
        this.dimensions = new ArrayList<Dimension>();
    }

    public DimArray(Array array, List<Dimension> dims) {
        this.array = array;
        this.dimensions = dims;
    }

    public Array getArray() {
        return this.array;
    }

    public void setArray(Array value) {
        this.array = value;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<Dimension> value) {
        this.dimensions = value;
    }

    public long getSize() {
        return this.array.getSize();
    }

    public Object getValue(int idx) {
        return this.array.getObject(idx);
    }

    public int getDimNum() {
        return this.dimensions.size();
    }

    public Dimension getDimension(int idx) {
        return this.dimensions.get(idx);
    }

    public void setDimension(int idx, Dimension dim) {
        this.dimensions.set(idx, dim);
    }

    public double getDimValue(int dimIdx, int vIdx) {
        return this.dimensions.get(dimIdx).getDimValue(vIdx);
    }

    public DimArray section(int[] origin, int[] size, int[] stride) throws InvalidRangeException {
        Array r = this.array.section(origin, size, stride);
        Array rr = Array.factory(r.getDataType(), r.getShape());
        MAMath.copy(rr, r);
        Section section = new Section(origin, size, stride);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (int i = 0; i < section.getRank(); ++i) {
            Range range = section.getRange(i);
            if (range.length() <= 1) continue;
            Dimension dim = this.dimensions.get(i).extract(range);
            dims.add(dim);
        }
        return new DimArray(rr, dims);
    }
}

