/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.internal.zmq;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.micromanager.internal.zmq.ParamSet;
import org.micromanager.internal.zmq.ZMQSocketWrapper;
import org.micromanager.internal.zmq.ZMQUtil;
import org.zeromq.SocketType;

public class ZMQServer
extends ZMQSocketWrapper {
    private ExecutorService executor_;
    private static Set<String> packages_;
    private static ZMQUtil util_;
    public static final String VERSION = "4.1.0";
    private static Function<Class, Object> classMapper_;
    private static ZMQServer masterServer_;
    static boolean debug_;
    private Consumer<String> debugLogger_;

    public ZMQServer() {
        super(SocketType.REP);
    }

    public ZMQServer(Collection<ClassLoader> cls, Function<Class, Object> classMapper, String[] excludePaths, Consumer<String> debugLogger) throws URISyntaxException, UnsupportedEncodingException {
        this(cls, classMapper, excludePaths, debugLogger, ZMQSocketWrapper.STARTING_PORT_NUMBER);
    }

    public ZMQServer(Collection<ClassLoader> cls, Function<Class, Object> classMapper, String[] excludePaths, Consumer<String> debugLogger, int port) throws URISyntaxException, UnsupportedEncodingException {
        super(SocketType.REP, port);
        classMapper_ = classMapper;
        util_ = new ZMQUtil(cls, excludePaths);
        packages_ = ZMQUtil.getPackages();
        for (ClassLoader cl : cls) {
            packages_.addAll(ZMQUtil.getPackagesFromJars((URLClassLoader)cl));
        }
        this.debugLogger_ = debugLogger;
    }

    public static ZMQServer getMasterServer() {
        return masterServer_;
    }

    @Override
    public void initialize(int port) {
        this.executor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "ZMQ Server "));
        this.executor_.submit(() -> {
            this.socket_ = context_.createSocket(this.type_);
            this.port_ = port;
            this.socket_.bind("tcp://127.0.0.1:" + port);
            while (true) {
                JSONObject message = this.receiveMessage();
                if (debug_) {
                    System.out.println("Recieved message: \t" + message);
                    this.debugLogger_.accept("Recieved message: \t" + message);
                }
                JSONObject reply = null;
                try {
                    reply = this.parseAndExecuteCommand(message);
                }
                catch (Exception e) {
                    try {
                        reply = new JSONObject();
                        reply.put("type", (Object)"exception");
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        String exceptionAsString = sw.toString();
                        reply.put("value", (Object)exceptionAsString);
                        e.printStackTrace();
                    }
                    catch (JSONException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (debug_) {
                    System.out.println("Sending message: \t" + reply.toString());
                    this.debugLogger_.accept("Sending message: \t" + reply.toString());
                }
                this.sendMessage(reply);
                if (!debug_) continue;
                System.out.println("Message sent");
                this.debugLogger_.accept("Message sent");
            }
        });
    }

    @Override
    public void close() {
        super.close();
        if (this.executor_ != null) {
            this.executor_.shutdownNow();
            this.socket_.close();
        }
    }

    protected JSONObject getField(Object obj, JSONObject json) throws JSONException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String fieldName = json.getString("name");
        Object field = obj.getClass().getField(fieldName).get(obj);
        JSONObject serialized = new JSONObject();
        util_.serialize(field, serialized, this.port_);
        return serialized;
    }

    protected void setField(Object obj, JSONObject json) throws JSONException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        String fieldName = json.getString("name");
        Object val = json.get("value");
        if (val instanceof JSONObject) {
            val = ZMQUtil.EXTERNAL_OBJECTS.get(((JSONObject)val).getString("hash-code"));
        }
        obj.getClass().getField(fieldName).set(obj, val);
    }

    private LinkedList<LinkedList<Class>> getParamCombos(JSONObject message, Object[] argVals) throws JSONException, UnsupportedEncodingException {
        for (int i = 0; i < argVals.length; ++i) {
            if (message.getJSONArray("arguments").get(i) instanceof JSONObject && message.getJSONArray("arguments").getJSONObject(i).has("hash-code")) {
                argVals[i] = ZMQUtil.EXTERNAL_OBJECTS.get(message.getJSONArray("arguments").getJSONObject(i).get("hash-code"));
                continue;
            }
            if (ZMQUtil.PRIMITIVE_NAME_CLASS_MAP.containsKey(message.getJSONArray("argument-deserialization-types").get(i))) {
                Object primitive = message.getJSONArray("arguments").get(i);
                Class<?> c = ZMQUtil.PRIMITIVE_NAME_CLASS_MAP.get(message.getJSONArray("argument-deserialization-types").get(i));
                argVals[i] = ZMQUtil.convertToPrimitiveClass(primitive, c);
                continue;
            }
            if (ZMQUtil.PRIMITIVE_ARRAY_NAME_CLASS_MAP.containsKey(message.getJSONArray("argument-deserialization-types").get(i))) {
                Class<?> c = ZMQUtil.PRIMITIVE_ARRAY_NAME_CLASS_MAP.get(message.getJSONArray("argument-deserialization-types").get(i));
                argVals[i] = message.getJSONArray("arguments").get(i);
                continue;
            }
            if (message.getJSONArray("argument-deserialization-types").get(i).equals("java.lang.String")) {
                if (message.getJSONArray("arguments").get(i) == JSONObject.NULL) {
                    argVals[i] = null;
                    continue;
                }
                argVals[i] = message.getJSONArray("arguments").getString(i);
                continue;
            }
            if (!message.getJSONArray("argument-deserialization-types").get(i).equals("java.lang.Object")) continue;
            argVals[i] = message.getJSONArray("arguments").get(i);
        }
        Object[] argClasses = new Object[message.getJSONArray("arguments").length()];
        for (int i = 0; i < argVals.length; ++i) {
            if (message.getJSONArray("arguments").get(i) instanceof JSONObject && message.getJSONArray("arguments").getJSONObject(i).has("hash-code")) {
                TreeSet<String> potentialPackages = new TreeSet<String>();
                Class<?> clazz = argVals[i].getClass();
                while (clazz.getSuperclass() != null) {
                    for (Class<?> clazz2 : clazz.getInterfaces()) {
                        potentialPackages.add(clazz2.getPackage().getName());
                    }
                    potentialPackages.add(clazz.getPackage().getName());
                    clazz = clazz.getSuperclass();
                }
                HashSet<Class> apiClasses = new HashSet<Class>();
                for (String packageName : potentialPackages) {
                    apiClasses.addAll(util_.getPackageClasses(packageName));
                }
                ParamSet potentialClasses = new ParamSet();
                for (Class clazz3 : apiClasses) {
                    if (!clazz3.isAssignableFrom(argVals[i].getClass())) continue;
                    potentialClasses.add(clazz3);
                }
                potentialClasses.add(argVals[i].getClass());
                argClasses[i] = potentialClasses;
                continue;
            }
            if (ZMQUtil.PRIMITIVE_NAME_CLASS_MAP.containsKey(message.getJSONArray("argument-types").get(i))) {
                argClasses[i] = ZMQUtil.PRIMITIVE_NAME_CLASS_MAP.get(message.getJSONArray("argument-types").get(i));
                continue;
            }
            if (ZMQUtil.PRIMITIVE_ARRAY_NAME_CLASS_MAP.containsKey(message.getJSONArray("argument-types").get(i))) {
                argClasses[i] = ZMQUtil.PRIMITIVE_ARRAY_NAME_CLASS_MAP.get(message.getJSONArray("argument-types").get(i));
                continue;
            }
            if (message.getJSONArray("argument-types").get(i).equals("java.lang.String")) {
                argClasses[i] = String.class;
                continue;
            }
            if (!message.getJSONArray("argument-types").get(i).equals("java.lang.Object")) continue;
            argClasses[i] = Object.class;
        }
        LinkedList<LinkedList<Class<Object>>> paramCombos = new LinkedList<LinkedList<Class>>();
        for (Object argument : argClasses) {
            if (argument instanceof ParamSet) {
                if (paramCombos.isEmpty()) {
                    for (Class clazz : (ParamSet)argument) {
                        paramCombos.add(new LinkedList());
                        paramCombos.getLast().add(clazz);
                    }
                    continue;
                }
                LinkedList newComboList = new LinkedList();
                for (Class c3 : (ParamSet)argument) {
                    for (LinkedList linkedList : paramCombos) {
                        LinkedList<Class> newArgList = new LinkedList<Class>(linkedList);
                        newArgList.add(c3);
                        newComboList.add(newArgList);
                    }
                }
                paramCombos = newComboList;
                continue;
            }
            if (paramCombos.isEmpty()) {
                paramCombos.add(new LinkedList());
            }
            for (LinkedList linkedList : paramCombos) {
                linkedList.add((Class)argument);
            }
        }
        return paramCombos;
    }

    private Object runConstructor(JSONObject message, Class baseClass) throws JSONException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, UnsupportedEncodingException {
        Object[] argVals = new Object[message.getJSONArray("arguments").length()];
        LinkedList<LinkedList<Class>> paramCombos = this.getParamCombos(message, argVals);
        Constructor mathcingConstructor = null;
        if (paramCombos.isEmpty()) {
            try {
                mathcingConstructor = baseClass.getConstructor(new Class[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        } else {
            for (LinkedList linkedList : paramCombos) {
                Class[] classArray = (Class[])linkedList.stream().toArray(Class[]::new);
                try {
                    mathcingConstructor = baseClass.getConstructor(classArray);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        if (mathcingConstructor == null) {
            throw new RuntimeException("No Matching method found with argumetn types");
        }
        return mathcingConstructor.newInstance(argVals);
    }

    private JSONObject runMethod(Object obj, JSONObject message) throws NoSuchMethodException, IllegalAccessException, JSONException, UnsupportedEncodingException {
        Object result;
        String methodName = message.getString("name");
        Object[] argVals = new Object[message.getJSONArray("arguments").length()];
        LinkedList<LinkedList<Class>> paramCombos = this.getParamCombos(message, argVals);
        Method matchingMethod = null;
        if (paramCombos.isEmpty()) {
            matchingMethod = obj.getClass().getMethod(methodName, new Class[0]);
        } else {
            for (LinkedList linkedList : paramCombos) {
                Method[] nameMatches;
                Class[] parameterTypes = (Class[])linkedList.stream().toArray(Class[]::new);
                for (Method m : nameMatches = (Method[])Stream.of(obj.getClass().getMethods()).filter(method -> method.getName().equals(methodName)).toArray(Method[]::new)) {
                    if (m.getParameters().length != parameterTypes.length) continue;
                    boolean matches = true;
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        if (m.getParameterTypes()[i].isAssignableFrom(parameterTypes[i])) continue;
                        matches = false;
                        break;
                    }
                    if (!matches) continue;
                    matchingMethod = m;
                }
            }
        }
        if (matchingMethod == null) {
            throw new RuntimeException("No Matching method found with argument types");
        }
        try {
            matchingMethod.setAccessible(true);
            result = matchingMethod.invoke(obj, argVals);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            result = invocationTargetException.getCause();
        }
        JSONObject jSONObject = new JSONObject();
        util_.serialize(result, jSONObject, this.port_);
        return jSONObject;
    }

    protected JSONObject parseAndExecuteCommand(JSONObject request) throws Exception {
        switch (request.getString("command")) {
            case "connect": {
                masterServer_ = this;
                debug_ = request.getBoolean("debug");
                JSONObject reply = new JSONObject();
                reply.put("type", (Object)"none");
                reply.put("version", (Object)VERSION);
                return reply;
            }
            case "get-constructors": {
                String classpath = request.getString("classpath");
                JSONObject reply = new JSONObject();
                reply.put("type", (Object)"none");
                reply.put("api", (Object)ZMQUtil.parseConstructors(classpath, classMapper_));
                return reply;
            }
            case "constructor": {
                Class baseClass = ZMQUtil.loadClass(request.getString("classpath"));
                if (baseClass == null) {
                    throw new RuntimeException("Couldnt find class with name" + request.getString("classpath"));
                }
                Object instance = classMapper_.apply(baseClass);
                if (instance == null) {
                    instance = this.runConstructor(request, baseClass);
                }
                if (request.has("new-port") && request.getBoolean("new-port")) {
                    new ZMQServer();
                }
                JSONObject reply = new JSONObject();
                util_.serialize(instance, reply, this.port_);
                return reply;
            }
            case "run-method": {
                String hashCode = request.getString("hash-code");
                Object target = ZMQUtil.EXTERNAL_OBJECTS.get(hashCode);
                return this.runMethod(target, request);
            }
            case "get-field": {
                String hashCode = request.getString("hash-code");
                Object target = ZMQUtil.EXTERNAL_OBJECTS.get(hashCode);
                return this.getField(target, request);
            }
            case "set-field": {
                String hashCode = request.getString("hash-code");
                Object target = ZMQUtil.EXTERNAL_OBJECTS.get(hashCode);
                this.setField(target, request);
                JSONObject reply = new JSONObject();
                reply.put("type", (Object)"none");
                return reply;
            }
            case "destructor": {
                String hashCode = request.getString("hash-code");
                Object removed = ZMQUtil.EXTERNAL_OBJECTS.remove(hashCode);
                if (debug_) {
                    System.out.println("Object ready for garbage collection: " + removed);
                }
                JSONObject reply = new JSONObject();
                reply.put("type", (Object)"none");
                return reply;
            }
        }
        throw new RuntimeException("Unknown Command");
    }

    static {
        debug_ = false;
    }
}

