/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import mmcorej.org.json.JSONArray;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.micromanager.acqj.api.AcquisitionAPI;
import org.micromanager.acqj.api.AcquisitionEvent;
import org.micromanager.acqj.api.AcquisitionHook;
import org.micromanager.internal.zmq.ZMQPullSocket;
import org.micromanager.internal.zmq.ZMQPushSocket;
import org.micromanager.remote.RemoteAcquisition;

public class RemoteAcqHook
implements AcquisitionHook {
    ZMQPushSocket<AcquisitionEvent> pushSocket_;
    ZMQPullSocket<List<AcquisitionEvent>> pullSocket_;

    public RemoteAcqHook(final AcquisitionAPI acq) {
        if (((RemoteAcquisition)acq).debugMode_) {
            ((RemoteAcquisition)acq).core_.logMessage("Making push socket");
        }
        this.pushSocket_ = new ZMQPushSocket<AcquisitionEvent>(new Function<AcquisitionEvent, JSONObject>(){

            @Override
            public JSONObject apply(AcquisitionEvent t) {
                return t.toJSON();
            }
        });
        if (((RemoteAcquisition)acq).debugMode_) {
            ((RemoteAcquisition)acq).core_.logMessage("Making pull socket");
        }
        this.pullSocket_ = new ZMQPullSocket<List<AcquisitionEvent>>(new Function<JSONObject, List<AcquisitionEvent>>(){

            @Override
            public List<AcquisitionEvent> apply(JSONObject t) {
                try {
                    ArrayList<AcquisitionEvent> eventList = new ArrayList<AcquisitionEvent>();
                    if (t.has("events")) {
                        JSONArray events = t.getJSONArray("events");
                        for (int i = 0; i < events.length(); ++i) {
                            JSONObject e = events.getJSONObject(i);
                            eventList.add(AcquisitionEvent.fromJSON((JSONObject)e, (AcquisitionAPI)acq));
                        }
                    } else {
                        eventList.add(AcquisitionEvent.fromJSON((JSONObject)t, (AcquisitionAPI)acq));
                    }
                    return eventList;
                }
                catch (JSONException ex) {
                    throw new RuntimeException("Incorrect format for acquisitio event");
                }
            }
        });
        if (((RemoteAcquisition)acq).debugMode_) {
            ((RemoteAcquisition)acq).core_.logMessage("made pull socket");
        }
    }

    public AcquisitionEvent run(AcquisitionEvent event) {
        this.pushSocket_.push(event);
        List<AcquisitionEvent> ae = this.pullSocket_.next();
        if (ae.size() == 1) {
            return ae.get(0);
        }
        return new AcquisitionEvent(ae);
    }

    public int getPullPort() {
        return this.pullSocket_.getPort();
    }

    public int getPushPort() {
        return this.pushSocket_.getPort();
    }

    public void close() {
        this.pushSocket_.close();
        this.pullSocket_.close();
    }
}

