/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.internal.zmq;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mmcorej.org.json.JSONArray;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;

public class ZMQUtil {
    private static Collection<ClassLoader> classLoaders_;
    private String[] excludedPaths_;
    private HashMap<String, Set<Class>> packageAPIClasses_ = new HashMap();
    protected static final ConcurrentHashMap<String, Object> EXTERNAL_OBJECTS;
    public static final Set<Class> PRIMITIVES;
    public static final Map<String, Class<?>> PRIMITIVE_NAME_CLASS_MAP;
    public static final Map<String, Class<?>> PRIMITIVE_ARRAY_NAME_CLASS_MAP;
    private static final ByteOrder BYTE_ORDER;

    public ZMQUtil(Collection<ClassLoader> cl, String[] excludePaths) {
        classLoaders_ = cl;
        this.excludedPaths_ = excludePaths;
    }

    static ArrayList<String> findPaths(String root, String extension) {
        ArrayList<String> result = new ArrayList<String>();
        if (!new File(root).isDirectory()) {
            if (root.endsWith(extension)) {
                result.add(root);
            }
            return result;
        }
        ZMQUtil.recursiveFindPaths(new File(root), extension, result);
        return result;
    }

    private static void recursiveFindPaths(File root, String extension, ArrayList<String> result) {
        File[] items;
        for (File item : items = root.listFiles()) {
            if (item.getAbsolutePath().endsWith(extension)) {
                result.add(item.getAbsolutePath());
                continue;
            }
            if (!item.isDirectory()) continue;
            ZMQUtil.recursiveFindPaths(item, extension, result);
        }
    }

    protected static Object deserialize(byte[] message, Function<JSONObject, ?> deserializationFn) {
        try {
            String s = new String(message);
            JSONObject json = new JSONObject(s);
            String type = json.getString("type");
            if (type.equals("object")) {
                Object result = deserializationFn.apply(json.getJSONObject("value"));
                return result;
            }
            throw new RuntimeException("Problem decoding message");
        }
        catch (JSONException ex) {
            throw new RuntimeException("Problem turning message into JSON. ");
        }
    }

    public static JSONObject toJSON(Object o) {
        JSONObject json;
        block13: {
            json = new JSONObject();
            try {
                if (o instanceof Exception) {
                    json.put("type", (Object)"exception");
                    Throwable root = ((Exception)o).getCause() == null ? (Exception)o : ((Exception)o).getCause();
                    String s = root.toString() + "\n";
                    for (StackTraceElement el : root.getStackTrace()) {
                        s = s + el.toString() + "\n";
                    }
                    json.put("value", (Object)s);
                    break block13;
                }
                if (o instanceof String) {
                    json.put("type", (Object)"string");
                    json.put("value", o);
                    break block13;
                }
                if (o == null) {
                    json.put("type", (Object)"none");
                    break block13;
                }
                if (PRIMITIVES.contains(o.getClass())) {
                    json.put("type", (Object)"primitive");
                    json.put("value", o);
                    break block13;
                }
                if (o.getClass().equals(JSONObject.class)) {
                    json.put("type", (Object)"object");
                    json.put("class", (Object)"JSONObject");
                    json.put("value", (Object)o.toString());
                    break block13;
                }
                if (o.getClass().equals(byte[].class)) {
                    json.put("type", (Object)"byte-array");
                    json.put("value", (Object)ZMQUtil.encodeArray(o));
                    break block13;
                }
                if (o.getClass().equals(short[].class)) {
                    json.put("type", (Object)"short-array");
                    json.put("value", (Object)ZMQUtil.encodeArray(o));
                    break block13;
                }
                if (o.getClass().equals(double[].class)) {
                    json.put("type", (Object)"double-array");
                    json.put("value", (Object)ZMQUtil.encodeArray(o));
                    break block13;
                }
                if (o.getClass().equals(int[].class)) {
                    json.put("type", (Object)"int-array");
                    json.put("value", (Object)ZMQUtil.encodeArray(o));
                    break block13;
                }
                if (o.getClass().equals(float[].class)) {
                    json.put("type", (Object)"float-array");
                    json.put("value", (Object)ZMQUtil.encodeArray(o));
                    break block13;
                }
                return null;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return json;
    }

    public void serialize(Object o, final JSONObject json, int port) {
        try {
            final JSONObject converted = ZMQUtil.toJSON(o);
            if (converted != null) {
                converted.keys().forEachRemaining(new Consumer<String>(){

                    @Override
                    public void accept(String t) {
                        try {
                            json.put(t, converted.get(t));
                        }
                        catch (JSONException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                });
            } else {
                String hash = Integer.toHexString(System.identityHashCode(o));
                hash = hash + UUID.randomUUID();
                EXTERNAL_OBJECTS.put(hash, o);
                json.put("type", (Object)"unserialized-object");
                json.put("class", (Object)o.getClass().getName());
                json.put("hash-code", (Object)hash);
                json.put("port", port);
                ArrayList<Class> apiInterfaces = new ArrayList<Class>();
                if (o.getClass().getName().startsWith("java")) {
                    for (Class<?> c : o.getClass().getInterfaces()) {
                        apiInterfaces.add(c);
                    }
                    apiInterfaces.add(o.getClass());
                } else {
                    HashSet packageNames = new HashSet();
                    Class<?> clazz = o.getClass();
                    do {
                        apiInterfaces.add(clazz);
                        Class<?>[] classArray = clazz.getInterfaces();
                        int n = classArray.length;
                        for (int i = 0; i < n; ++i) {
                            Class<?> inter = classArray[i];
                            apiInterfaces.add(inter);
                            this.recursiveAddInterfaces(apiInterfaces, inter);
                        }
                    } while ((clazz = clazz.getSuperclass()) != null);
                }
                if (apiInterfaces.isEmpty()) {
                    throw new RuntimeException("Couldn't find " + o.getClass().getName() + " on classpath, or this is an internal class that was accidentally exposed");
                }
                JSONArray e = new JSONArray();
                json.put("interfaces", (Object)e);
                for (Class c : apiInterfaces) {
                    e.put((Object)c.getName());
                }
                JSONArray f = new JSONArray();
                json.put("fields", (Object)f);
                for (Field field : o.getClass().getFields()) {
                    int modifiers = field.getModifiers();
                    if (!Modifier.isPublic(modifiers)) continue;
                    f.put((Object)field.getName());
                }
                json.put("api", (Object)ZMQUtil.parseAPI(apiInterfaces));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private void recursiveAddInterfaces(ArrayList<Class> apiInterfaces, Class inter) {
        for (Class<?> extendedInterface : inter.getInterfaces()) {
            apiInterfaces.add(extendedInterface);
            this.recursiveAddInterfaces(apiInterfaces, extendedInterface);
        }
    }

    public static byte[] encodeArray(Object array) {
        byte[] byteArray = null;
        if (array instanceof byte[]) {
            byteArray = (byte[])array;
        } else if (array instanceof short[]) {
            ByteBuffer buffer = ByteBuffer.allocate(((short[])array).length * 2);
            buffer.order(BYTE_ORDER).asShortBuffer().put((short[])array);
            byteArray = buffer.array();
        } else if (array instanceof int[]) {
            ByteBuffer buffer = ByteBuffer.allocate(((int[])array).length * 4);
            buffer.order(BYTE_ORDER).asIntBuffer().put((int[])array);
            byteArray = buffer.array();
        } else if (array instanceof double[]) {
            ByteBuffer buffer = ByteBuffer.allocate(((double[])array).length * 8);
            buffer.order(BYTE_ORDER).asDoubleBuffer().put((double[])array);
            byteArray = buffer.array();
        } else if (array instanceof float[]) {
            ByteBuffer buffer = ByteBuffer.allocate(((float[])array).length * 4);
            buffer.order(BYTE_ORDER).asFloatBuffer().put((float[])array);
            byteArray = buffer.array();
        }
        return byteArray;
    }

    public static Object decodeArray(byte[] byteArray, Class arrayClass) {
        if (arrayClass.equals(byte[].class)) {
            return byteArray;
        }
        if (arrayClass.equals(short[].class)) {
            short[] shorts = new short[byteArray.length / 2];
            ByteBuffer.wrap(byteArray).order(ByteOrder.nativeOrder()).asShortBuffer().get(shorts);
            return shorts;
        }
        if (arrayClass.equals(int[].class)) {
            int[] ints = new int[byteArray.length / 4];
            ByteBuffer.wrap(byteArray).order(ByteOrder.nativeOrder()).asIntBuffer().get(ints);
            return ints;
        }
        if (arrayClass.equals(double[].class)) {
            double[] doubles = new double[byteArray.length / 8];
            ByteBuffer.wrap(byteArray).order(ByteOrder.nativeOrder()).asDoubleBuffer().get(doubles);
            return doubles;
        }
        if (arrayClass.equals(float[].class)) {
            float[] floats = new float[byteArray.length / 4];
            ByteBuffer.wrap(byteArray).order(ByteOrder.nativeOrder()).asFloatBuffer().get(floats);
            return floats;
        }
        throw new RuntimeException("unknown array type");
    }

    public static JSONArray parseConstructors(String classpath, Function<Class, Object> classMapper) throws JSONException, ClassNotFoundException {
        Constructor<?>[] m;
        JSONArray methodArray = new JSONArray();
        Class clazz = ZMQUtil.loadClass(classpath);
        for (Constructor<?> c : m = clazz.getConstructors()) {
            JSONObject methJSON = new JSONObject();
            methJSON.put("name", (Object)c.getName());
            JSONArray args = new JSONArray();
            for (Class<?> arg : c.getParameterTypes()) {
                args.put((Object)arg.getCanonicalName());
            }
            methJSON.put("arguments", (Object)args);
            methodArray.put((Object)methJSON);
        }
        if (clazz.isInterface() && classMapper.apply(clazz) != null) {
            JSONObject methJSON = new JSONObject();
            methJSON.put("name", (Object)clazz.getName());
            JSONArray args = new JSONArray();
            methJSON.put("arguments", (Object)args);
            methodArray.put((Object)methJSON);
        }
        return methodArray;
    }

    private static JSONArray parseAPI(ArrayList<Class> apiClasses) throws JSONException {
        JSONArray methodArray = new JSONArray();
        for (Class clazz : apiClasses) {
            for (Method method : clazz.getDeclaredMethods()) {
                JSONObject methJSON = new JSONObject();
                methJSON.put("name", (Object)method.getName());
                methJSON.put("return-type", (Object)method.getReturnType().getTypeName());
                JSONArray args = new JSONArray();
                for (Class<?> arg : method.getParameterTypes()) {
                    args.put((Object)arg.getTypeName());
                }
                methJSON.put("arguments", (Object)args);
                methodArray.put((Object)methJSON);
            }
        }
        return methodArray;
    }

    public static Collection<String> getPackagesFromJars(URLClassLoader cl) {
        HashSet<String> packages = new HashSet<String>();
        for (URL u : cl.getURLs()) {
            try {
                ZipInputStream zip = new ZipInputStream(new FileInputStream(URLDecoder.decode(u.getFile(), "UTF-8")));
                ZipEntry entry = zip.getNextEntry();
                while (entry != null) {
                    if (!entry.isDirectory() && entry.getName().endsWith(".class") && !entry.getName().contains("$")) {
                        String className = entry.getName().replace('/', '.');
                        className = className.substring(0, className.length() - 6);
                        try {
                            Class clazz = ZMQUtil.loadClass(className);
                            try {
                                if (clazz.getPackage() != null) {
                                    packages.add(clazz.getPackage().getName());
                                }
                            }
                            catch (Exception exception) {}
                        }
                        catch (IllegalAccessError illegalAccessError) {
                            // empty catch block
                        }
                    }
                    entry = zip.getNextEntry();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return packages;
    }

    public static Set<String> getPackages() {
        Package[] p;
        HashSet<String> packages = new HashSet<String>();
        for (Package pa : p = Package.getPackages()) {
            packages.add(pa.getName());
        }
        return packages;
    }

    protected static Class loadClass(String path) {
        for (ClassLoader cl : classLoaders_) {
            try {
                return cl.loadClass(path);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
        }
        throw new RuntimeException("Class not found on any classloaders");
    }

    public Set<Class> getPackageClasses(String packageName) throws UnsupportedEncodingException {
        if (this.packageAPIClasses_.containsKey(packageName)) {
            return this.packageAPIClasses_.get(packageName);
        }
        HashSet<Class> packageClasses = new HashSet<Class>();
        if (!packageName.contains("java.")) {
            for (ClassLoader classLoader : classLoaders_) {
                Enumeration<URL> resources;
                String path = packageName.replace('.', '/');
                try {
                    resources = classLoader.getResources(path);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Invalid package name in ZMQ server: " + path);
                }
                ArrayList<File> dirs = new ArrayList<File>();
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    String file = resource.getFile().replaceAll("^file:", "");
                    file = URLDecoder.decode(file, "UTF-8");
                    dirs.add(new File(file));
                }
                for (File directory : dirs) {
                    if (directory.getAbsolutePath().contains(".jar")) {
                        packageClasses.addAll(ZMQUtil.getClassesFromJarFile(directory));
                        continue;
                    }
                    packageClasses.addAll(ZMQUtil.getClassesFromDirectory(packageName, directory));
                }
            }
        }
        Stream clazzStream = packageClasses.stream();
        Set<Class> classSet = clazzStream.filter(new Predicate<Class>(){

            @Override
            public boolean test(Class t) {
                Package p = t.getPackage();
                if (p == null) {
                    return true;
                }
                for (String exclude : ZMQUtil.this.excludedPaths_) {
                    if (!t.getPackage().getName().contains(exclude)) continue;
                    return false;
                }
                return true;
            }
        }).collect(Collectors.toSet());
        this.packageAPIClasses_.put(packageName, classSet);
        return classSet;
    }

    private static Collection<Class> getClassesFromJarFile(File directory) {
        ArrayList<Class> classes = new ArrayList<Class>();
        try {
            String jarPath = Stream.of(directory.getAbsolutePath().split(File.pathSeparator)).flatMap(t -> Stream.of(t.split("!"))).filter(t -> t.contains(".jar")).findFirst().get();
            JarFile jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class") || name.contains("$")) continue;
                try {
                    classes.add(Class.forName(name.replace("/", ".").substring(0, name.length() - 6)));
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return classes;
    }

    private static Collection<Class> getClassesFromDirectory(String packageName, File directory) {
        ArrayList<Class> classes = new ArrayList<Class>();
        List<File> jarFiles = ZMQUtil.listFiles(directory, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        }, false);
        for (File file : jarFiles) {
            classes.addAll(ZMQUtil.getClassesFromJarFile(file));
        }
        List<File> classFiles = ZMQUtil.listFiles(directory, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        }, true);
        for (File file : classFiles) {
            if (file.isDirectory()) continue;
            try {
                classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return classes;
    }

    private static List<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries;
        ArrayList<File> files = new ArrayList<File>();
        for (File entry : entries = directory.listFiles()) {
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(ZMQUtil.listFiles(entry, filter, recurse));
        }
        return files;
    }

    static Object convertToPrimitiveClass(Object primitive, Class argClass) {
        if (argClass.equals(Boolean.TYPE)) {
            return primitive;
        }
        if (argClass.equals(Character.TYPE)) {
            return Character.valueOf((char)((Number)primitive).intValue());
        }
        if (argClass.equals(Byte.TYPE)) {
            return ((Number)primitive).byteValue();
        }
        if (argClass.equals(Short.TYPE)) {
            return ((Number)primitive).shortValue();
        }
        if (argClass.equals(Integer.TYPE)) {
            return ((Number)primitive).intValue();
        }
        if (argClass.equals(Long.TYPE)) {
            return ((Number)primitive).longValue();
        }
        if (argClass.equals(Float.TYPE)) {
            return Float.valueOf(((Number)primitive).floatValue());
        }
        if (argClass.equals(Double.TYPE)) {
            return ((Number)primitive).doubleValue();
        }
        throw new RuntimeException("Unknown class");
    }

    public static Object convertToPrimitiveArray(Object argClass, String value) {
        byte[] bytes = new byte[]{};
        bytes = value.getBytes(StandardCharsets.ISO_8859_1);
        if (argClass.equals(byte[].class)) {
            return bytes;
        }
        if (argClass.equals(short[].class)) {
            short[] shorts = new short[bytes.length / 2];
            ByteBuffer.wrap(bytes).asShortBuffer().get(shorts);
            return shorts;
        }
        if (argClass.equals(int[].class)) {
            int[] ints = new int[bytes.length / 4];
            ByteBuffer.wrap(bytes).asIntBuffer().get(ints);
            return ints;
        }
        if (argClass.equals(double[].class)) {
            double[] doubles = new double[bytes.length / 8];
            ByteBuffer.wrap(bytes).asDoubleBuffer().get(doubles);
            return doubles;
        }
        throw new RuntimeException("Unknown class");
    }

    static {
        EXTERNAL_OBJECTS = new ConcurrentHashMap();
        PRIMITIVES = new HashSet<Class>();
        PRIMITIVE_NAME_CLASS_MAP = new HashMap();
        PRIMITIVE_ARRAY_NAME_CLASS_MAP = new HashMap();
        PRIMITIVES.add(Boolean.class);
        PRIMITIVES.add(Byte.class);
        PRIMITIVES.add(Short.class);
        PRIMITIVES.add(Character.class);
        PRIMITIVES.add(Integer.class);
        PRIMITIVES.add(Long.class);
        PRIMITIVES.add(Float.class);
        PRIMITIVES.add(Double.class);
        PRIMITIVE_NAME_CLASS_MAP.put("boolean", Boolean.TYPE);
        PRIMITIVE_NAME_CLASS_MAP.put("byte", Byte.TYPE);
        PRIMITIVE_NAME_CLASS_MAP.put("short", Short.TYPE);
        PRIMITIVE_NAME_CLASS_MAP.put("char", Character.TYPE);
        PRIMITIVE_NAME_CLASS_MAP.put("int", Integer.TYPE);
        PRIMITIVE_NAME_CLASS_MAP.put("long", Long.TYPE);
        PRIMITIVE_NAME_CLASS_MAP.put("float", Float.TYPE);
        PRIMITIVE_NAME_CLASS_MAP.put("double", Double.TYPE);
        PRIMITIVE_ARRAY_NAME_CLASS_MAP.put("boolean[]", boolean[].class);
        PRIMITIVE_ARRAY_NAME_CLASS_MAP.put("byte[]", byte[].class);
        PRIMITIVE_ARRAY_NAME_CLASS_MAP.put("short[]", short[].class);
        PRIMITIVE_ARRAY_NAME_CLASS_MAP.put("char[]", char[].class);
        PRIMITIVE_ARRAY_NAME_CLASS_MAP.put("int[]", int[].class);
        PRIMITIVE_ARRAY_NAME_CLASS_MAP.put("long[]", long[].class);
        PRIMITIVE_ARRAY_NAME_CLASS_MAP.put("float[]", float[].class);
        PRIMITIVE_ARRAY_NAME_CLASS_MAP.put("double[]", double[].class);
        BYTE_ORDER = ByteOrder.nativeOrder();
    }
}

