/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import mmcorej.org.json.JSONArray;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.micromanager.acqj.api.AcquisitionAPI;
import org.micromanager.acqj.api.AcquisitionEvent;
import org.micromanager.internal.zmq.ZMQPullSocket;
import org.micromanager.remote.RemoteAcquisition;

public class RemoteEventSource {
    private ZMQPullSocket<List<AcquisitionEvent>> pullSocket_;
    private RemoteAcquisition acq_;
    private ExecutorService executor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Remote Event Source thread"));

    public RemoteEventSource() {
        this.pullSocket_ = new ZMQPullSocket<List>(t -> {
            try {
                ArrayList<AcquisitionEvent> eventList = new ArrayList<AcquisitionEvent>();
                JSONArray events = t.getJSONArray("events");
                for (int i = 0; i < events.length(); ++i) {
                    JSONObject e = events.getJSONObject(i);
                    eventList.add(AcquisitionEvent.fromJSON((JSONObject)e, (AcquisitionAPI)this.acq_));
                }
                return eventList;
            }
            catch (JSONException ex) {
                throw new RuntimeException("Incorrect format for acquisitio event");
            }
        });
        this.executor_.submit(() -> {
            while (true) {
                try {
                    boolean finished;
                    do {
                        List<AcquisitionEvent> eList = this.pullSocket_.next();
                        finished = eList.get(eList.size() - 1).isAcquisitionFinishedEvent();
                        Future result = this.acq_.submitEventIterator(eList.iterator());
                        result.get();
                    } while (!finished && !this.executor_.isShutdown());
                    this.executor_.shutdown();
                    this.pullSocket_.close();
                    return;
                }
                catch (ExecutionException ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage());
                    continue;
                }
                catch (Exception e) {
                    if (this.executor_.isShutdown()) {
                        return;
                    }
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                break;
            }
        });
    }

    void setAcquisition(RemoteAcquisition aThis) {
        this.acq_ = aThis;
    }

    public int getPort() {
        return this.pullSocket_.getPort();
    }

    void abort() {
        this.executor_.shutdownNow();
        this.pullSocket_.close();
    }
}

