/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;
import mmcorej.TaggedImage;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.micromanager.acqj.api.AcqEngMetadata;
import org.micromanager.acqj.api.TaggedImageProcessor;
import org.micromanager.internal.zmq.ZMQPullSocket;
import org.micromanager.internal.zmq.ZMQPushSocket;
import org.micromanager.internal.zmq.ZMQUtil;

public class RemoteImageProcessor
implements TaggedImageProcessor {
    private ExecutorService pushExecutor_;
    private ExecutorService pullExecutor_;
    volatile LinkedBlockingDeque<TaggedImage> source_;
    volatile LinkedBlockingDeque<TaggedImage> sink_;
    ZMQPushSocket<TaggedImage> pushSocket_ = new ZMQPushSocket<TaggedImage>(new Function<TaggedImage, JSONObject>(){

        @Override
        public JSONObject apply(TaggedImage t) {
            try {
                JSONObject json = new JSONObject();
                if (t.tags == null && t.pix == null) {
                    json.put("special", (Object)"finished");
                } else {
                    json.put("metadata", (Object)t.tags);
                    json.put("pixels", (Object)ZMQUtil.toJSON(t.pix));
                }
                return json;
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
    });
    ZMQPullSocket<TaggedImage> pullSocket_ = new ZMQPullSocket<TaggedImage>(new Function<JSONObject, TaggedImage>(){

        @Override
        public TaggedImage apply(JSONObject t) {
            try {
                JSONObject tags;
                if (t instanceof JSONObject && t.has("special") && t.getString("special").equals("finished")) {
                    return new TaggedImage(null, null);
                }
                Object pix = ZMQUtil.decodeArray((byte[])t.get("pixels"), AcqEngMetadata.getBytesPerPixel((JSONObject)(tags = t.getJSONObject("metadata"))) == 1 || AcqEngMetadata.getBytesPerPixel((JSONObject)tags) == 4 ? byte[].class : short[].class);
                return new TaggedImage(pix, tags);
            }
            catch (JSONException ex) {
                throw new RuntimeException(ex);
            }
        }
    });

    public RemoteImageProcessor() {
        this.pushExecutor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Tagged Image socket push"));
        this.pullExecutor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Tagged Image socket pull"));
    }

    public int getPullPort() {
        return this.pullSocket_.getPort();
    }

    public int getPushPort() {
        return this.pushSocket_.getPort();
    }

    public void startPush() {
        this.pushExecutor_.submit(() -> {
            while (true) {
                if (this.source_ == null) {
                    continue;
                }
                try {
                    TaggedImage img = this.source_.takeFirst();
                    this.pushSocket_.push(img);
                    continue;
                }
                catch (InterruptedException ex) {
                    return;
                }
                catch (Exception e) {
                    if (this.pullExecutor_.isShutdown()) {
                        return;
                    }
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
    }

    public void startPull() {
        this.pullExecutor_.submit(() -> {
            while (true) {
                if (this.sink_ == null) {
                    continue;
                }
                try {
                    TaggedImage ti = this.pullSocket_.next();
                    this.sink_.putLast(ti);
                    continue;
                }
                catch (InterruptedException ex) {
                    return;
                }
                catch (Exception e) {
                    if (this.pullExecutor_.isShutdown()) {
                        return;
                    }
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
    }

    public void setDequeues(LinkedBlockingDeque<TaggedImage> source, LinkedBlockingDeque<TaggedImage> sink) {
        this.source_ = source;
        this.sink_ = sink;
    }

    public void close() {
        this.pullExecutor_.shutdownNow();
        this.pushExecutor_.shutdownNow();
        this.pushSocket_.close();
        this.pullSocket_.close();
    }
}

