/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mmcorej.TaggedImage;
import mmcorej.org.json.JSONObject;
import org.micromanager.acqj.api.DataSink;
import org.micromanager.acqj.internal.Engine;
import org.micromanager.acqj.main.AcqEngMetadata;
import org.micromanager.acqj.main.Acquisition;
import org.micromanager.ndtiffstorage.MultiresNDTiffAPI;
import org.micromanager.ndtiffstorage.NDTiffAPI;
import org.micromanager.ndtiffstorage.NDTiffStorage;
import org.micromanager.ndviewer.api.DataSourceInterface;
import org.micromanager.ndviewer.api.ViewerAcquisitionInterface;
import org.micromanager.ndviewer.api.ViewerInterface;
import org.micromanager.ndviewer.main.NDViewer;

class RemoteViewerStorageAdapter
implements DataSourceInterface,
DataSink {
    private ExecutorService displayCommunicationExecutor_;
    private volatile ViewerInterface viewer_;
    private volatile Acquisition acq_;
    private volatile MultiresNDTiffAPI storage_;
    private final boolean showViewer_;
    private final boolean storeData_;
    private final boolean xyTiled_;
    private final int tileOverlapX_;
    private final int tileOverlapY_;
    private String dir_;
    private String name_;
    private Integer maxResLevel_;
    private int savingQueueSize_;
    private volatile boolean finished_ = false;

    public RemoteViewerStorageAdapter(boolean showViewer, String dataStorageLocation, String name, boolean xyTiled, int tileOverlapX, int tileOverlapY, Integer maxResLevel, int savingQueueSize) {
        this.showViewer_ = showViewer;
        this.storeData_ = dataStorageLocation != null;
        this.xyTiled_ = xyTiled;
        this.dir_ = dataStorageLocation;
        this.name_ = name;
        this.tileOverlapX_ = tileOverlapX;
        this.tileOverlapY_ = tileOverlapY;
        this.maxResLevel_ = maxResLevel;
        this.savingQueueSize_ = savingQueueSize;
    }

    public void initialize(Acquisition acq, JSONObject summaryMetadata) {
        this.acq_ = acq;
        if (this.storeData_) {
            if (this.xyTiled_) {
                AcqEngMetadata.setWidth((JSONObject)summaryMetadata, (int)((int)Engine.getCore().getImageWidth()));
                AcqEngMetadata.setHeight((JSONObject)summaryMetadata, (int)((int)Engine.getCore().getImageHeight()));
            }
            this.storage_ = new NDTiffStorage(this.dir_, this.name_, summaryMetadata, this.tileOverlapX_, this.tileOverlapY_, this.xyTiled_, this.maxResLevel_, this.savingQueueSize_, this.acq_.isDebugMode() ? s -> Engine.getCore().logMessage(s) : null, true);
            this.name_ = this.storage_.getUniqueAcqName();
        }
        if (this.showViewer_) {
            this.createDisplay(summaryMetadata);
        }
    }

    public ViewerInterface getViewer() {
        return this.viewer_;
    }

    public NDTiffAPI getStorage() {
        return this.storage_;
    }

    private void createDisplay(JSONObject summaryMetadata) {
        this.displayCommunicationExecutor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Image viewer communication thread"));
        this.viewer_ = new NDViewer((DataSourceInterface)this, (ViewerAcquisitionInterface)this.acq_, summaryMetadata, AcqEngMetadata.getPixelSizeUm((JSONObject)summaryMetadata), AcqEngMetadata.isRGB((JSONObject)summaryMetadata));
        this.viewer_.setWindowTitle(this.name_ + (this.acq_ != null ? (this.acq_.areEventsFinished() ? " (Finished)" : " (Running)") : " (Loaded)"));
        this.viewer_.setReadTimeMetadataFunction(tags -> AcqEngMetadata.getElapsedTimeMs((JSONObject)tags));
        this.viewer_.setReadZMetadataFunction(tags -> AcqEngMetadata.getStageZIntended((JSONObject)tags));
    }

    public void putImage(final TaggedImage taggedImg) {
        Future added;
        HashMap axes = AcqEngMetadata.getAxes((JSONObject)taggedImg.tags);
        if (this.xyTiled_) {
            axes.put("column", AcqEngMetadata.getGridCol((JSONObject)taggedImg.tags));
            axes.put("row", AcqEngMetadata.getGridRow((JSONObject)taggedImg.tags));
            added = this.storage_.putImageMultiRes(taggedImg.pix, taggedImg.tags, axes, AcqEngMetadata.isRGB((JSONObject)taggedImg.tags), AcqEngMetadata.getBitDepth((JSONObject)taggedImg.tags), AcqEngMetadata.getHeight((JSONObject)taggedImg.tags), AcqEngMetadata.getWidth((JSONObject)taggedImg.tags));
        } else {
            added = null;
            this.storage_.putImage(taggedImg.pix, taggedImg.tags, axes, AcqEngMetadata.isRGB((JSONObject)taggedImg.tags), AcqEngMetadata.getBitDepth((JSONObject)taggedImg.tags), AcqEngMetadata.getHeight((JSONObject)taggedImg.tags), AcqEngMetadata.getWidth((JSONObject)taggedImg.tags));
        }
        if (this.showViewer_) {
            this.displayCommunicationExecutor_.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (added != null) {
                            added.get();
                        }
                    }
                    catch (Exception e) {
                        Engine.getCore().logMessage(e.getMessage());
                        throw new RuntimeException(e);
                    }
                    HashMap axes = AcqEngMetadata.getAxes((JSONObject)taggedImg.tags);
                    if (RemoteViewerStorageAdapter.this.xyTiled_) {
                        axes.remove("row");
                        axes.remove("column");
                    }
                    RemoteViewerStorageAdapter.this.viewer_.newImageArrived(axes);
                }
            });
        }
    }

    public int[] getBounds() {
        return this.storage_.getImageBounds();
    }

    public TaggedImage getImageForDisplay(HashMap<String, Object> axes, int resolutionindex, double xOffset, double yOffset, int imageWidth, int imageHeight) {
        return this.storage_.getDisplayImage(axes, resolutionindex, (int)xOffset, (int)yOffset, imageWidth, imageHeight);
    }

    public Set<HashMap<String, Object>> getImageKeys() {
        return this.storage_.getAxesSet();
    }

    public int getMaxResolutionIndex() {
        return this.storage_.getNumResLevels() - 1;
    }

    public String getDiskLocation() {
        return this.dir_;
    }

    public void close() {
        this.storage_.close();
    }

    public int getImageBitDepth(HashMap<String, Object> axesPositions) {
        return this.storage_.getEssentialImageMetadata(axesPositions).bitDepth;
    }

    public void finish() {
        if (this.storage_ != null) {
            if (!this.storage_.isFinished()) {
                if (this.viewer_ != null) {
                    JSONObject displaySettings = this.viewer_.getDisplaySettingsJSON();
                    this.storage_.setDisplaySettings(displaySettings);
                }
                this.storage_.finishedWriting();
            }
            if (!this.showViewer_) {
                this.close();
            }
        }
        if (this.showViewer_) {
            this.viewer_.setWindowTitle(this.name_ + " (Finished)");
            this.displayCommunicationExecutor_.shutdown();
        }
        this.finished_ = true;
    }

    public boolean isFinished() {
        return this.finished_;
    }

    public boolean anythingAcquired() {
        return this.acq_.anythingAcquired();
    }

    boolean isXYTiled() {
        return this.xyTiled_;
    }

    int getOverlapX() {
        return this.tileOverlapX_;
    }

    int getOverlapY() {
        return this.tileOverlapY_;
    }
}

