/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import org.micromanager.acqj.api.AcquisitionAPI;
import org.micromanager.acqj.api.DataSink;
import org.micromanager.acqj.main.Acquisition;
import org.micromanager.acqj.main.XYTiledAcquisition;
import org.micromanager.ndtiffstorage.NDTiffAPI;
import org.micromanager.ndviewer.api.ViewerAcquisitionInterface;
import org.micromanager.remote.RemoteEventSource;
import org.micromanager.remote.RemoteViewerStorageAdapter;

public class XYTiledRemoteAcquisition
extends XYTiledAcquisition
implements AcquisitionAPI,
ViewerAcquisitionInterface {
    private RemoteEventSource eventSource_;

    public XYTiledRemoteAcquisition(RemoteEventSource eventSource, RemoteViewerStorageAdapter sink, boolean debug) {
        super((DataSink)sink, Integer.valueOf(sink.getOverlapX()), Integer.valueOf(sink.getOverlapY()));
        this.setDebugMode(debug);
        this.eventSource_ = eventSource;
        eventSource.setAcquisition((Acquisition)this);
    }

    public NDTiffAPI getStorage() {
        return this.getDataSink() == null ? null : ((RemoteViewerStorageAdapter)this.getDataSink()).getStorage();
    }

    public int getEventPort() {
        return this.eventSource_.getPort();
    }

    public void abort() {
        super.abort();
        this.eventSource_.abort();
    }

    public void togglePaused() {
        this.setPaused(!this.isPaused());
    }

    public void abort(Exception e) {
        super.abort(e);
        this.eventSource_.abort();
    }

    public boolean isFinished() {
        if (this.getDataSink() != null) {
            return this.eventSource_.isFinished() && this.getDataSink().isFinished();
        }
        return this.eventSource_.isFinished();
    }
}

