/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.remote;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Function;
import mmcorej.CMMCore;
import mmcorej.MMEventCallback;
import mmcorej.org.json.JSONArray;
import mmcorej.org.json.JSONException;
import mmcorej.org.json.JSONObject;
import org.micromanager.internal.zmq.ZMQPushSocket;

public final class RemoteCoreCallback
extends MMEventCallback {
    private ExecutorService pushExecutor_;
    private ZMQPushSocket<JSONObject> pushSocket_;
    volatile LinkedBlockingDeque<JSONObject> eventList_ = new LinkedBlockingDeque();
    private final CMMCore core_;

    public RemoteCoreCallback(CMMCore core) {
        this.core_ = core;
        this.core_.registerCallback((MMEventCallback)this);
        this.pushSocket_ = new ZMQPushSocket<JSONObject>(new Function<JSONObject, JSONObject>(){

            @Override
            public JSONObject apply(JSONObject t) {
                return t;
            }
        });
        this.pushExecutor_ = Executors.newSingleThreadExecutor(r -> new Thread(r, "Core callback thread"));
    }

    public int getPushPort() {
        return this.pushSocket_.getPort();
    }

    public void shutdown() {
        this.pushExecutor_.shutdownNow();
        this.pushSocket_.close();
    }

    public void startPush() {
        this.pushExecutor_.submit(() -> {
            while (true) {
                try {
                    while (true) {
                        JSONObject message = this.eventList_.takeFirst();
                        this.pushSocket_.push(message);
                    }
                }
                catch (InterruptedException ex) {
                    return;
                }
                catch (Exception e) {
                    if (this.pushExecutor_.isShutdown()) {
                        return;
                    }
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
    }

    public void onPropertiesChanged() {
        try {
            JSONObject message = new JSONObject();
            message.put("name", (Object)"propertiesChanged");
            this.eventList_.addLast(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.core_.logMessage(e.toString());
        }
    }

    public void onPropertyChanged(String deviceName, String propName, String propValue) {
        try {
            JSONObject message = new JSONObject();
            message.put("name", (Object)"propertyChanged");
            JSONArray args = new JSONArray();
            args.put((Object)deviceName);
            args.put((Object)propName);
            args.put((Object)propValue);
            message.put("arguments", (Object)args);
            this.eventList_.addLast(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.core_.logMessage(e.toString());
        }
    }

    public void onChannelGroupChanged(String newChannelGroupName) {
        try {
            JSONObject message = new JSONObject();
            message.put("name", (Object)"channelGroupChanged");
            JSONArray args = new JSONArray();
            args.put((Object)newChannelGroupName);
            message.put("arguments", (Object)args);
            this.eventList_.addLast(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.core_.logMessage(e.toString());
        }
    }

    public void onConfigGroupChanged(String groupName, String newConfig) {
        try {
            JSONObject message = new JSONObject();
            message.put("name", (Object)"configGroupChanged");
            JSONArray args = new JSONArray();
            args.put((Object)groupName);
            args.put((Object)newConfig);
            message.put("arguments", (Object)args);
            this.eventList_.addLast(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.core_.logMessage(e.toString());
        }
    }

    public void onSystemConfigurationLoaded() {
        try {
            JSONObject message = new JSONObject();
            message.put("name", (Object)"systemConfigurationLoaded");
            this.eventList_.addLast(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.core_.logMessage(e.toString());
        }
    }

    public void onPixelSizeChanged(double newPixelSizeUm) {
        try {
            JSONObject message = new JSONObject();
            message.put("name", (Object)"pixelSizeChanged");
            JSONArray args = new JSONArray();
            args.put(newPixelSizeUm);
            message.put("arguments", (Object)args);
            this.eventList_.addLast(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.core_.logMessage(e.toString());
        }
    }

    public void onPixelSizeAffineChanged(double npa0, double npa1, double npa2, double npa3, double npa4, double npa5) {
        try {
            JSONObject message = new JSONObject();
            message.put("name", (Object)"pixelSizeAffineChanged");
            JSONArray args = new JSONArray();
            args.put(npa0);
            args.put(npa1);
            args.put(npa2);
            args.put(npa3);
            args.put(npa4);
            args.put(npa5);
            message.put("arguments", (Object)args);
            this.eventList_.addLast(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.core_.logMessage(e.toString());
        }
    }

    public void onStagePositionChanged(String deviceName, double pos) {
        try {
            JSONObject message = new JSONObject();
            message.put("name", (Object)"stagePositionChanged");
            JSONArray args = new JSONArray();
            args.put((Object)deviceName);
            args.put(pos);
            message.put("arguments", (Object)args);
            this.eventList_.addLast(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.core_.logMessage(e.toString());
        }
    }

    public void onXYStagePositionChanged(String deviceName, double xPos, double yPos) {
        try {
            JSONObject message = new JSONObject();
            message.put("name", (Object)"XYStagePositionChanged");
            JSONArray args = new JSONArray();
            args.put((Object)deviceName);
            args.put(xPos);
            args.put(yPos);
            message.put("arguments", (Object)args);
            this.eventList_.addLast(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.core_.logMessage(e.toString());
        }
    }

    public void onExposureChanged(String deviceName, double exposure) {
        try {
            JSONObject message = new JSONObject();
            message.put("name", (Object)"exposureChanged");
            JSONArray args = new JSONArray();
            args.put((Object)deviceName);
            args.put(exposure);
            message.put("arguments", (Object)args);
            this.eventList_.addLast(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.core_.logMessage(e.toString());
        }
    }

    public void onSLMExposureChanged(String deviceName, double exposure) {
        try {
            JSONObject message = new JSONObject();
            message.put("name", (Object)"SLMExposureChanged");
            JSONArray args = new JSONArray();
            args.put((Object)deviceName);
            args.put(exposure);
            message.put("arguments", (Object)args);
            this.eventList_.addLast(message);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.core_.logMessage(e.toString());
        }
    }
}

